// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SmoothCommonPluginInfo.C
// ****************************************************************************

#include <SmoothPluginInfo.h>
#include <SmoothOperatorAttributes.h>

// ****************************************************************************
//  Method: SmoothCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SmoothCommonPluginInfo::AllocAttributes()
{
    return new SmoothOperatorAttributes;
}

// ****************************************************************************
//  Method: SmoothCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Smooth attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SmoothCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SmoothOperatorAttributes *) to) = *((SmoothOperatorAttributes *) from);
}
