// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SliceScriptingPluginInfo.C
// ************************************************************************* //
#include <PySliceAttributes.h>
#include <SlicePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Slice,Scripting)

// ****************************************************************************
// Method: SliceScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SliceScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySliceAttributes_StartUp((SliceAttributes *)subj, data);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SliceScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySliceAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Slice plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SliceScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySliceAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SliceScriptingPluginInfo::GetLogString()
{
    std::string s(PySliceAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SliceScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SliceScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySliceAttributes_SetDefaults((const SliceAttributes *)atts);
}
