// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SPHResampleViewerEnginePluginInfo.C
// ****************************************************************************

#include <SPHResamplePluginInfo.h>
#include <SPHResampleAttributes.h>

//
// Storage for static data elements.
//
SPHResampleAttributes *SPHResampleViewerEnginePluginInfo::clientAtts = NULL;
SPHResampleAttributes *SPHResampleViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  SPHResampleViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
SPHResampleViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (SPHResampleViewerEnginePluginInfo::clientAtts == NULL)
    {
        SPHResampleViewerEnginePluginInfo::clientAtts  = new SPHResampleAttributes;
        SPHResampleViewerEnginePluginInfo::defaultAtts = new SPHResampleAttributes;
    }
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SPHResampleViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SPHResampleViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SPHResampleViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(SPHResampleAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SPHResampleViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(SPHResampleAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SPHResampleViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(SPHResampleAttributes*)atts = *defaultAtts;
    else
        *(SPHResampleAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SPHResampleViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: SPHResampleViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
SPHResampleViewerEnginePluginInfo::GetMenuName() const
{
    return "SPH Resample";
}

