// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  SPHResampleScriptingPluginInfo.C
// ************************************************************************* //
#include <PySPHResampleAttributes.h>
#include <SPHResamplePluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SPHResample,Scripting)

// ****************************************************************************
// Method: SPHResampleScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SPHResampleScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PySPHResampleAttributes_StartUp((SPHResampleAttributes *)subj, data);
}

// ****************************************************************************
// Method: SPHResampleScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
SPHResampleScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PySPHResampleAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: SPHResampleScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is SPHResample plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PySPHResampleAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: SPHResampleScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
SPHResampleScriptingPluginInfo::GetLogString()
{
    std::string s(PySPHResampleAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: SPHResampleScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SPHResampleScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PySPHResampleAttributes_SetDefaults((const SPHResampleAttributes *)atts);
}
