// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SPHResamplePluginInfo.h
// ****************************************************************************

#ifndef SPHRESAMPLE_PLUGIN_INFO_H
#define SPHRESAMPLE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class SPHResampleAttributes;

// ****************************************************************************
//  Class: SPHResamplePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an SPHResample operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class SPHResampleGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class SPHResampleCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual SPHResampleGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class SPHResampleGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual SPHResampleCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class SPHResampleViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual SPHResampleCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static SPHResampleAttributes *defaultAtts;
    static SPHResampleAttributes *clientAtts;
};

class SPHResampleViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual SPHResampleViewerEnginePluginInfo
{
  public:
};

class SPHResampleEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual SPHResampleViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class SPHResampleScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual SPHResampleCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
