// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SPHResampleGUIPluginInfo.C
// ****************************************************************************

#include <SPHResamplePluginInfo.h>
#include <SPHResampleAttributes.h>
#include <QApplication>
#include <QvisSPHResampleWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(SPHResample,GUI)

// ****************************************************************************
//  Method: SPHResampleGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
SPHResampleGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "SPH Resample"));
}


// ****************************************************************************
//  Method: SPHResampleGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
SPHResampleGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisSPHResampleWindow(type, (SPHResampleAttributes *)attr,
        caption, shortName, notepad);
}

