// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: SPHResampleCommonPluginInfo.C
// ****************************************************************************

#include <SPHResamplePluginInfo.h>
#include <SPHResampleAttributes.h>

// ****************************************************************************
//  Method: SPHResampleCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
SPHResampleCommonPluginInfo::AllocAttributes()
{
    return new SPHResampleAttributes;
}

// ****************************************************************************
//  Method: SPHResampleCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a SPHResample attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
SPHResampleCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((SPHResampleAttributes *) to) = *((SPHResampleAttributes *) from);
}
