// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <SPHResampleAttributes.h>
#include <DataNode.h>

// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Init utility for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SPHResampleAttributes::Init()
{
    minX = 0;
    maxX = 1;
    xnum = 10;
    minY = 0;
    maxY = 1;
    ynum = 10;
    minZ = 0;
    maxZ = 1;
    znum = 10;
    RK = true;

    SPHResampleAttributes::SelectAll();
}

// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Copy utility for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void SPHResampleAttributes::Copy(const SPHResampleAttributes &obj)
{
    minX = obj.minX;
    maxX = obj.maxX;
    xnum = obj.xnum;
    minY = obj.minY;
    maxY = obj.maxY;
    ynum = obj.ynum;
    minZ = obj.minZ;
    maxZ = obj.maxZ;
    znum = obj.znum;
    tensorSupportVariable = obj.tensorSupportVariable;
    weightVariable = obj.weightVariable;
    RK = obj.RK;

    SPHResampleAttributes::SelectAll();
}

// Type map format string
const char *SPHResampleAttributes::TypeMapFormatString = SPHRESAMPLEATTRIBUTES_TMFS;
const AttributeGroup::private_tmfs_t SPHResampleAttributes::TmfsStruct = {SPHRESAMPLEATTRIBUTES_TMFS};


// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Default constructor for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes::SPHResampleAttributes() :
    AttributeSubject(SPHResampleAttributes::TypeMapFormatString),
    tensorSupportVariable("H"), weightVariable("mass")
{
    SPHResampleAttributes::Init();
}

// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Constructor for the derived classes of SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes::SPHResampleAttributes(private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs),
    tensorSupportVariable("H"), weightVariable("mass")
{
    SPHResampleAttributes::Init();
}

// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Copy constructor for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes::SPHResampleAttributes(const SPHResampleAttributes &obj) :
    AttributeSubject(SPHResampleAttributes::TypeMapFormatString)
{
    SPHResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SPHResampleAttributes::SPHResampleAttributes
//
// Purpose:
//   Copy constructor for derived classes of the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes::SPHResampleAttributes(const SPHResampleAttributes &obj, private_tmfs_t tmfs) :
    AttributeSubject(tmfs.tmfs)
{
    SPHResampleAttributes::Copy(obj);
}

// ****************************************************************************
// Method: SPHResampleAttributes::~SPHResampleAttributes
//
// Purpose:
//   Destructor for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes::~SPHResampleAttributes()
{
    // nothing here
}

// ****************************************************************************
// Method: SPHResampleAttributes::operator =
//
// Purpose:
//   Assignment operator for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

SPHResampleAttributes&
SPHResampleAttributes::operator = (const SPHResampleAttributes &obj)
{
    if (this == &obj) return *this;

    SPHResampleAttributes::Copy(obj);

    return *this;
}

// ****************************************************************************
// Method: SPHResampleAttributes::operator ==
//
// Purpose:
//   Comparison operator == for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleAttributes::operator == (const SPHResampleAttributes &obj) const
{
    // Create the return value
    return ((minX == obj.minX) &&
            (maxX == obj.maxX) &&
            (xnum == obj.xnum) &&
            (minY == obj.minY) &&
            (maxY == obj.maxY) &&
            (ynum == obj.ynum) &&
            (minZ == obj.minZ) &&
            (maxZ == obj.maxZ) &&
            (znum == obj.znum) &&
            (tensorSupportVariable == obj.tensorSupportVariable) &&
            (weightVariable == obj.weightVariable) &&
            (RK == obj.RK));
}

// ****************************************************************************
// Method: SPHResampleAttributes::operator !=
//
// Purpose:
//   Comparison operator != for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleAttributes::operator != (const SPHResampleAttributes &obj) const
{
    return !(this->operator == (obj));
}

// ****************************************************************************
// Method: SPHResampleAttributes::TypeName
//
// Purpose:
//   Type name method for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

const std::string
SPHResampleAttributes::TypeName() const
{
    return "SPHResampleAttributes";
}

// ****************************************************************************
// Method: SPHResampleAttributes::CopyAttributes
//
// Purpose:
//   CopyAttributes method for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleAttributes::CopyAttributes(const AttributeGroup *atts)
{
    if(TypeName() != atts->TypeName())
        return false;

    // Call assignment operator.
    const SPHResampleAttributes *tmp = (const SPHResampleAttributes *)atts;
    *this = *tmp;

    return true;
}

// ****************************************************************************
// Method: SPHResampleAttributes::CreateCompatible
//
// Purpose:
//   CreateCompatible method for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SPHResampleAttributes::CreateCompatible(const std::string &tname) const
{
    AttributeSubject *retval = 0;
    if(TypeName() == tname)
        retval = new SPHResampleAttributes(*this);
    // Other cases could go here too.

    return retval;
}

// ****************************************************************************
// Method: SPHResampleAttributes::NewInstance
//
// Purpose:
//   NewInstance method for the SPHResampleAttributes class.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeSubject *
SPHResampleAttributes::NewInstance(bool copy) const
{
    AttributeSubject *retval = 0;
    if(copy)
        retval = new SPHResampleAttributes(*this);
    else
        retval = new SPHResampleAttributes;

    return retval;
}

// ****************************************************************************
// Method: SPHResampleAttributes::SelectAll
//
// Purpose:
//   Selects all attributes.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SPHResampleAttributes::SelectAll()
{
    Select(ID_minX,                  (void *)&minX);
    Select(ID_maxX,                  (void *)&maxX);
    Select(ID_xnum,                  (void *)&xnum);
    Select(ID_minY,                  (void *)&minY);
    Select(ID_maxY,                  (void *)&maxY);
    Select(ID_ynum,                  (void *)&ynum);
    Select(ID_minZ,                  (void *)&minZ);
    Select(ID_maxZ,                  (void *)&maxZ);
    Select(ID_znum,                  (void *)&znum);
    Select(ID_tensorSupportVariable, (void *)&tensorSupportVariable);
    Select(ID_weightVariable,        (void *)&weightVariable);
    Select(ID_RK,                    (void *)&RK);
}

///////////////////////////////////////////////////////////////////////////////
// Persistence methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SPHResampleAttributes::CreateNode
//
// Purpose:
//   This method creates a DataNode representation of the object so it can be saved to a config file.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleAttributes::CreateNode(DataNode *parentNode, bool completeSave, bool forceAdd)
{
    if(parentNode == 0)
        return false;

    SPHResampleAttributes defaultObject;
    bool addToParent = false;
    // Create a node for SPHResampleAttributes.
    DataNode *node = new DataNode("SPHResampleAttributes");

    if(completeSave || !FieldsEqual(ID_minX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minX", minX));
    }

    if(completeSave || !FieldsEqual(ID_maxX, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxX", maxX));
    }

    if(completeSave || !FieldsEqual(ID_xnum, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("xnum", xnum));
    }

    if(completeSave || !FieldsEqual(ID_minY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minY", minY));
    }

    if(completeSave || !FieldsEqual(ID_maxY, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxY", maxY));
    }

    if(completeSave || !FieldsEqual(ID_ynum, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("ynum", ynum));
    }

    if(completeSave || !FieldsEqual(ID_minZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("minZ", minZ));
    }

    if(completeSave || !FieldsEqual(ID_maxZ, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("maxZ", maxZ));
    }

    if(completeSave || !FieldsEqual(ID_znum, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("znum", znum));
    }

    if(completeSave || !FieldsEqual(ID_tensorSupportVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("tensorSupportVariable", tensorSupportVariable));
    }

    if(completeSave || !FieldsEqual(ID_weightVariable, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("weightVariable", weightVariable));
    }

    if(completeSave || !FieldsEqual(ID_RK, &defaultObject))
    {
        addToParent = true;
        node->AddNode(new DataNode("RK", RK));
    }


    // Add the node to the parent node.
    if(addToParent || forceAdd)
        parentNode->AddNode(node);
    else
        delete node;

    return (addToParent || forceAdd);
}

// ****************************************************************************
// Method: SPHResampleAttributes::SetFromNode
//
// Purpose:
//   This method sets attributes in this object from values in a DataNode representation of the object.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
SPHResampleAttributes::SetFromNode(DataNode *parentNode)
{
    if(parentNode == 0)
        return;

    DataNode *searchNode = parentNode->GetNode("SPHResampleAttributes");
    if(searchNode == 0)
        return;

    DataNode *node;
    if((node = searchNode->GetNode("minX")) != 0)
        SetMinX(node->AsFloat());
    if((node = searchNode->GetNode("maxX")) != 0)
        SetMaxX(node->AsFloat());
    if((node = searchNode->GetNode("xnum")) != 0)
        SetXnum(node->AsInt());
    if((node = searchNode->GetNode("minY")) != 0)
        SetMinY(node->AsFloat());
    if((node = searchNode->GetNode("maxY")) != 0)
        SetMaxY(node->AsFloat());
    if((node = searchNode->GetNode("ynum")) != 0)
        SetYnum(node->AsInt());
    if((node = searchNode->GetNode("minZ")) != 0)
        SetMinZ(node->AsFloat());
    if((node = searchNode->GetNode("maxZ")) != 0)
        SetMaxZ(node->AsFloat());
    if((node = searchNode->GetNode("znum")) != 0)
        SetZnum(node->AsInt());
    if((node = searchNode->GetNode("tensorSupportVariable")) != 0)
        SetTensorSupportVariable(node->AsString());
    if((node = searchNode->GetNode("weightVariable")) != 0)
        SetWeightVariable(node->AsString());
    if((node = searchNode->GetNode("RK")) != 0)
        SetRK(node->AsBool());
}

///////////////////////////////////////////////////////////////////////////////
// Set property methods
///////////////////////////////////////////////////////////////////////////////

void
SPHResampleAttributes::SetMinX(float minX_)
{
    minX = minX_;
    Select(ID_minX, (void *)&minX);
}

void
SPHResampleAttributes::SetMaxX(float maxX_)
{
    maxX = maxX_;
    Select(ID_maxX, (void *)&maxX);
}

void
SPHResampleAttributes::SetXnum(int xnum_)
{
    xnum = xnum_;
    Select(ID_xnum, (void *)&xnum);
}

void
SPHResampleAttributes::SetMinY(float minY_)
{
    minY = minY_;
    Select(ID_minY, (void *)&minY);
}

void
SPHResampleAttributes::SetMaxY(float maxY_)
{
    maxY = maxY_;
    Select(ID_maxY, (void *)&maxY);
}

void
SPHResampleAttributes::SetYnum(int ynum_)
{
    ynum = ynum_;
    Select(ID_ynum, (void *)&ynum);
}

void
SPHResampleAttributes::SetMinZ(float minZ_)
{
    minZ = minZ_;
    Select(ID_minZ, (void *)&minZ);
}

void
SPHResampleAttributes::SetMaxZ(float maxZ_)
{
    maxZ = maxZ_;
    Select(ID_maxZ, (void *)&maxZ);
}

void
SPHResampleAttributes::SetZnum(int znum_)
{
    znum = znum_;
    Select(ID_znum, (void *)&znum);
}

void
SPHResampleAttributes::SetTensorSupportVariable(const std::string &tensorSupportVariable_)
{
    tensorSupportVariable = tensorSupportVariable_;
    Select(ID_tensorSupportVariable, (void *)&tensorSupportVariable);
}

void
SPHResampleAttributes::SetWeightVariable(const std::string &weightVariable_)
{
    weightVariable = weightVariable_;
    Select(ID_weightVariable, (void *)&weightVariable);
}

void
SPHResampleAttributes::SetRK(bool RK_)
{
    RK = RK_;
    Select(ID_RK, (void *)&RK);
}

///////////////////////////////////////////////////////////////////////////////
// Get property methods
///////////////////////////////////////////////////////////////////////////////

float
SPHResampleAttributes::GetMinX() const
{
    return minX;
}

float
SPHResampleAttributes::GetMaxX() const
{
    return maxX;
}

int
SPHResampleAttributes::GetXnum() const
{
    return xnum;
}

float
SPHResampleAttributes::GetMinY() const
{
    return minY;
}

float
SPHResampleAttributes::GetMaxY() const
{
    return maxY;
}

int
SPHResampleAttributes::GetYnum() const
{
    return ynum;
}

float
SPHResampleAttributes::GetMinZ() const
{
    return minZ;
}

float
SPHResampleAttributes::GetMaxZ() const
{
    return maxZ;
}

int
SPHResampleAttributes::GetZnum() const
{
    return znum;
}

const std::string &
SPHResampleAttributes::GetTensorSupportVariable() const
{
    return tensorSupportVariable;
}

std::string &
SPHResampleAttributes::GetTensorSupportVariable()
{
    return tensorSupportVariable;
}

const std::string &
SPHResampleAttributes::GetWeightVariable() const
{
    return weightVariable;
}

std::string &
SPHResampleAttributes::GetWeightVariable()
{
    return weightVariable;
}

bool
SPHResampleAttributes::GetRK() const
{
    return RK;
}

///////////////////////////////////////////////////////////////////////////////
// Select property methods
///////////////////////////////////////////////////////////////////////////////

void
SPHResampleAttributes::SelectTensorSupportVariable()
{
    Select(ID_tensorSupportVariable, (void *)&tensorSupportVariable);
}

void
SPHResampleAttributes::SelectWeightVariable()
{
    Select(ID_weightVariable, (void *)&weightVariable);
}

///////////////////////////////////////////////////////////////////////////////
// Keyframing methods
///////////////////////////////////////////////////////////////////////////////

// ****************************************************************************
// Method: SPHResampleAttributes::GetFieldName
//
// Purpose:
//   This method returns the name of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SPHResampleAttributes::GetFieldName(int index) const
{
    switch (index)
    {
    case ID_minX:                  return "minX";
    case ID_maxX:                  return "maxX";
    case ID_xnum:                  return "xnum";
    case ID_minY:                  return "minY";
    case ID_maxY:                  return "maxY";
    case ID_ynum:                  return "ynum";
    case ID_minZ:                  return "minZ";
    case ID_maxZ:                  return "maxZ";
    case ID_znum:                  return "znum";
    case ID_tensorSupportVariable: return "tensorSupportVariable";
    case ID_weightVariable:        return "weightVariable";
    case ID_RK:                    return "RK";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SPHResampleAttributes::GetFieldType
//
// Purpose:
//   This method returns the type of a field given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

AttributeGroup::FieldType
SPHResampleAttributes::GetFieldType(int index) const
{
    switch (index)
    {
    case ID_minX:                  return FieldType_float;
    case ID_maxX:                  return FieldType_float;
    case ID_xnum:                  return FieldType_int;
    case ID_minY:                  return FieldType_float;
    case ID_maxY:                  return FieldType_float;
    case ID_ynum:                  return FieldType_int;
    case ID_minZ:                  return FieldType_float;
    case ID_maxZ:                  return FieldType_float;
    case ID_znum:                  return FieldType_int;
    case ID_tensorSupportVariable: return FieldType_variablename;
    case ID_weightVariable:        return FieldType_variablename;
    case ID_RK:                    return FieldType_bool;
    default:  return FieldType_unknown;
    }
}

// ****************************************************************************
// Method: SPHResampleAttributes::GetFieldTypeName
//
// Purpose:
//   This method returns the name of a field type given its index.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

std::string
SPHResampleAttributes::GetFieldTypeName(int index) const
{
    switch (index)
    {
    case ID_minX:                  return "float";
    case ID_maxX:                  return "float";
    case ID_xnum:                  return "int";
    case ID_minY:                  return "float";
    case ID_maxY:                  return "float";
    case ID_ynum:                  return "int";
    case ID_minZ:                  return "float";
    case ID_maxZ:                  return "float";
    case ID_znum:                  return "int";
    case ID_tensorSupportVariable: return "variablename";
    case ID_weightVariable:        return "variablename";
    case ID_RK:                    return "bool";
    default:  return "invalid index";
    }
}

// ****************************************************************************
// Method: SPHResampleAttributes::FieldsEqual
//
// Purpose:
//   This method compares two fields and return true if they are equal.
//
// Note:       Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
SPHResampleAttributes::FieldsEqual(int index_, const AttributeGroup *rhs) const
{
    const SPHResampleAttributes &obj = *((const SPHResampleAttributes*)rhs);
    bool retval = false;
    switch (index_)
    {
    case ID_minX:
        {  // new scope
        retval = (minX == obj.minX);
        }
        break;
    case ID_maxX:
        {  // new scope
        retval = (maxX == obj.maxX);
        }
        break;
    case ID_xnum:
        {  // new scope
        retval = (xnum == obj.xnum);
        }
        break;
    case ID_minY:
        {  // new scope
        retval = (minY == obj.minY);
        }
        break;
    case ID_maxY:
        {  // new scope
        retval = (maxY == obj.maxY);
        }
        break;
    case ID_ynum:
        {  // new scope
        retval = (ynum == obj.ynum);
        }
        break;
    case ID_minZ:
        {  // new scope
        retval = (minZ == obj.minZ);
        }
        break;
    case ID_maxZ:
        {  // new scope
        retval = (maxZ == obj.maxZ);
        }
        break;
    case ID_znum:
        {  // new scope
        retval = (znum == obj.znum);
        }
        break;
    case ID_tensorSupportVariable:
        {  // new scope
        retval = (tensorSupportVariable == obj.tensorSupportVariable);
        }
        break;
    case ID_weightVariable:
        {  // new scope
        retval = (weightVariable == obj.weightVariable);
        }
        break;
    case ID_RK:
        {  // new scope
        retval = (RK == obj.RK);
        }
        break;
    default: retval = false;
    }

    return retval;
}

///////////////////////////////////////////////////////////////////////////////
// User-defined methods.
///////////////////////////////////////////////////////////////////////////////

