// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISSPHRESAMPLEWINDOW_H
#define QVISSPHRESAMPLEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class SPHResampleAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisSPHResampleWindow
//
// Purpose:
//    Defines QvisSPHResampleWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisSPHResampleWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisSPHResampleWindow(const int type,
                         SPHResampleAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisSPHResampleWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void minXProcessText();
    void maxXProcessText();
    void xnumProcessText();
    void minYProcessText();
    void maxYProcessText();
    void ynumProcessText();
    void minZProcessText();
    void maxZProcessText();
    void znumProcessText();
    void tensorSupportVariableChanged(const QString &varName);
    void weightVariableChanged(const QString &varName);
    void RKChanged(bool val);
  private:
    QLineEdit *minX;
    QLineEdit *maxX;
    QLineEdit *xnum;
    QLineEdit *minY;
    QLineEdit *maxY;
    QLineEdit *ynum;
    QLineEdit *minZ;
    QLineEdit *maxZ;
    QLineEdit *znum;
    QvisVariableButton *tensorSupportVariable;
    QvisVariableButton *weightVariable;
    QCheckBox *RK;
    QLabel *minXLabel;
    QLabel *maxXLabel;
    QLabel *xnumLabel;
    QLabel *minYLabel;
    QLabel *maxYLabel;
    QLabel *ynumLabel;
    QLabel *minZLabel;
    QLabel *maxZLabel;
    QLabel *znumLabel;
    QLabel *tensorSupportVariableLabel;
    QLabel *weightVariableLabel;

    SPHResampleAttributes *atts;
};



#endif
