// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ResamplePluginInfo.h
// ****************************************************************************

#ifndef RESAMPLE_PLUGIN_INFO_H
#define RESAMPLE_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ResampleAttributes;

// ****************************************************************************
//  Class: ResamplePluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Resample operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ResampleGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ResampleCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ResampleGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ResampleGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ResampleViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ResampleAttributes *defaultAtts;
    static ResampleAttributes *clientAtts;
};

class ResampleViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ResampleViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ResampleEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ResampleViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ResampleScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ResampleCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
