// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISRESAMPLEWINDOW_H
#define QVISRESAMPLEWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ResampleAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QButtonGroup;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisResampleWindow
//
// Purpose:
//    Defines QvisResampleWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
//    Hank Childs, Wed Dec 31 14:26:57 PST 2008
//    Renamed ResamplePluginAttributes to ResampleAttributes.
//
// ****************************************************************************

class QvisResampleWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisResampleWindow(const int type,
                         ResampleAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisResampleWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void useExtentsChanged(bool val);
    void startXProcessText();
    void endXProcessText();
    void samplesXProcessText();
    void startYProcessText();
    void endYProcessText();
    void samplesYProcessText();
    void is3DChanged(bool val);
    void startZProcessText();
    void endZProcessText();
    void samplesZProcessText();
    void tieResolverChanged(int val);
    void tieResolverVariableChanged(const QString &varName);
    void defaultValueProcessText();
    void distributedResampleChanged(bool val);
    void cellCenteredOutputChanged(bool val);
  private:
    QCheckBox *useExtents;
    QLineEdit *startX;
    QLineEdit *endX;
    QLineEdit *samplesX;
    QLineEdit *startY;
    QLineEdit *endY;
    QLineEdit *samplesY;
    QCheckBox *is3D;
    QLineEdit *startZ;
    QLineEdit *endZ;
    QLineEdit *samplesZ;
    QButtonGroup *tieResolver;
    QvisVariableButton *tieResolverVariable;
    QLineEdit *defaultValue;
    QCheckBox *distributedResample;
    QCheckBox *cellCenteredOutput;
    QLabel *startXLabel;
    QLabel *endXLabel;
    QLabel *samplesXLabel;
    QLabel *startYLabel;
    QLabel *endYLabel;
    QLabel *samplesYLabel;
    QLabel *startZLabel;
    QLabel *endZLabel;
    QLabel *samplesZLabel;
    QLabel *tieResolverLabel;
    QLabel *tieResolverVariableLabel;
    QLabel *defaultValueLabel;

    ResampleAttributes *atts;
};



#endif
