// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReplicateGUIPluginInfo.C
// ****************************************************************************

#include <ReplicatePluginInfo.h>
#include <ReplicateAttributes.h>
#include <QApplication>
#include <QvisReplicateWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Replicate,GUI)

// ****************************************************************************
//  Method: ReplicateGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
ReplicateGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Replicate"));
}


// ****************************************************************************
//  Method: ReplicateGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
ReplicateGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisReplicateWindow(type, (ReplicateAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: ReplicateGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <Replicate.xpm>
const char **
ReplicateGUIPluginInfo::XPMIconData() const
{
    return Replicate_xpm;
}

