// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RemoveCellsViewerEnginePluginInfo.C
// ****************************************************************************

#include <RemoveCellsPluginInfo.h>
#include <RemoveCellsAttributes.h>

//
// Storage for static data elements.
//
RemoveCellsAttributes *RemoveCellsViewerEnginePluginInfo::clientAtts = NULL;
RemoveCellsAttributes *RemoveCellsViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  RemoveCellsViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
RemoveCellsViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (RemoveCellsViewerEnginePluginInfo::clientAtts == NULL)
    {
        RemoveCellsViewerEnginePluginInfo::clientAtts  = new RemoveCellsAttributes;
        RemoveCellsViewerEnginePluginInfo::defaultAtts = new RemoveCellsAttributes;
    }
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RemoveCellsViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RemoveCellsViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RemoveCellsViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(RemoveCellsAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RemoveCellsViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(RemoveCellsAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RemoveCellsViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(RemoveCellsAttributes*)atts = *defaultAtts;
    else
        *(RemoveCellsAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RemoveCellsViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: RemoveCellsViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
RemoveCellsViewerEnginePluginInfo::GetMenuName() const
{
    return "RemoveCells";
}

