// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  RemoveCellsScriptingPluginInfo.C
// ************************************************************************* //
#include <PyRemoveCellsAttributes.h>
#include <RemoveCellsPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(RemoveCells,Scripting)

// ****************************************************************************
// Method: RemoveCellsScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemoveCellsScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyRemoveCellsAttributes_StartUp((RemoveCellsAttributes *)subj, data);
}

// ****************************************************************************
// Method: RemoveCellsScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
RemoveCellsScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyRemoveCellsAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: RemoveCellsScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is RemoveCells plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemoveCellsScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyRemoveCellsAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: RemoveCellsScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
RemoveCellsScriptingPluginInfo::GetLogString()
{
    std::string s(PyRemoveCellsAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: RemoveCellsScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemoveCellsScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyRemoveCellsAttributes_SetDefaults((const RemoveCellsAttributes *)atts);
}
