// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RemoveCellsPluginInfo.h
// ****************************************************************************

#ifndef REMOVECELLS_PLUGIN_INFO_H
#define REMOVECELLS_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class RemoveCellsAttributes;

// ****************************************************************************
//  Class: RemoveCellsPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an RemoveCells operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class RemoveCellsGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class RemoveCellsCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual RemoveCellsGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class RemoveCellsGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual RemoveCellsCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class RemoveCellsViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual RemoveCellsCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static RemoveCellsAttributes *defaultAtts;
    static RemoveCellsAttributes *clientAtts;
};

class RemoveCellsViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual RemoveCellsViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class RemoveCellsEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual RemoveCellsViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class RemoveCellsScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual RemoveCellsCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
