// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RemoveCellsCommonPluginInfo.C
// ****************************************************************************

#include <RemoveCellsPluginInfo.h>
#include <RemoveCellsAttributes.h>

// ****************************************************************************
//  Method: RemoveCellsCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RemoveCellsCommonPluginInfo::AllocAttributes()
{
    return new RemoveCellsAttributes;
}

// ****************************************************************************
//  Method: RemoveCellsCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a RemoveCells attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RemoveCellsCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((RemoveCellsAttributes *) to) = *((RemoveCellsAttributes *) from);
}
