// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef REMOVECELLSATTRIBUTES_H
#define REMOVECELLSATTRIBUTES_H
#include <AttributeSubject.h>


// ****************************************************************************
// Class: RemoveCellsAttributes
//
// Purpose:
//    This class contains attributes for the RemoveCells operator.
//
// Notes:      Autogenerated by xml2atts.
//
// Programmer: xml2atts
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

class RemoveCellsAttributes : public AttributeSubject
{
public:
    // These constructors are for objects of this class
    RemoveCellsAttributes();
    RemoveCellsAttributes(const RemoveCellsAttributes &obj);
protected:
    // These constructors are for objects derived from this class
    RemoveCellsAttributes(private_tmfs_t tmfs);
    RemoveCellsAttributes(const RemoveCellsAttributes &obj, private_tmfs_t tmfs);
public:
    virtual ~RemoveCellsAttributes();

    virtual RemoveCellsAttributes& operator = (const RemoveCellsAttributes &obj);
    virtual bool operator == (const RemoveCellsAttributes &obj) const;
    virtual bool operator != (const RemoveCellsAttributes &obj) const;
private:
    void Init();
    void Copy(const RemoveCellsAttributes &obj);
public:

    virtual const std::string TypeName() const;
    virtual bool CopyAttributes(const AttributeGroup *);
    virtual AttributeSubject *CreateCompatible(const std::string &) const;
    virtual AttributeSubject *NewInstance(bool) const;

    // Property selection methods
    virtual void SelectAll();
    void SelectCellList();
    void SelectDomainList();

    // Property setting methods
    void SetCellList(const intVector &cellList_);
    void SetDomainList(const intVector &domainList_);

    // Property getting methods
    const intVector &GetCellList() const;
          intVector &GetCellList();
    const intVector &GetDomainList() const;
          intVector &GetDomainList();

    // Persistence methods
    virtual bool CreateNode(DataNode *node, bool completeSave, bool forceAdd);
    virtual void SetFromNode(DataNode *node);


    // Keyframing methods
    virtual std::string               GetFieldName(int index) const;
    virtual AttributeGroup::FieldType GetFieldType(int index) const;
    virtual std::string               GetFieldTypeName(int index) const;
    virtual bool                      FieldsEqual(int index, const AttributeGroup *rhs) const;


    // IDs that can be used to identify fields in case statements
    enum {
        ID_cellList = 0,
        ID_domainList,
        ID__LAST
    };

private:
    intVector cellList;
    intVector domainList;

    // Static class format string for type map.
    static const char *TypeMapFormatString;
    static const private_tmfs_t TmfsStruct;
};
#define REMOVECELLSATTRIBUTES_TMFS "i*i*"

#endif
