// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  RemapScriptingPluginInfo.C
// ************************************************************************* //
#include <PyRemapAttributes.h>
#include <RemapPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(Remap,Scripting)

// ****************************************************************************
// Method: RemapScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemapScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyRemapAttributes_StartUp((RemapAttributes *)subj, data);
}

// ****************************************************************************
// Method: RemapScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
RemapScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyRemapAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: RemapScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is Remap plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
RemapScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyRemapAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: RemapScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
RemapScriptingPluginInfo::GetLogString()
{
    std::string s(PyRemapAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: RemapScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
RemapScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyRemapAttributes_SetDefaults((const RemapAttributes *)atts);
}
