// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISREMAPWINDOW_H
#define QVISREMAPWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class RemapAttributes;
class QLabel;
class QCheckBox;
class QLineEdit;
class QSpinBox;
class QButtonGroup;
class QvisVariableButton;

// ****************************************************************************
// Class: QvisRemapWindow
//
// Purpose:
//    Defines QvisRemapWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

class QvisRemapWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisRemapWindow(const int type,
                         RemapAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisRemapWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void useExtentsChanged(bool val);
    void startXProcessText();
    void endXProcessText();
    void cellsXProcessText();
    void startYProcessText();
    void endYProcessText();
    void cellsYProcessText();
    void is3DChanged(bool val);
    void startZProcessText();
    void endZProcessText();
    void cellsZProcessText();
    void variableTypeChanged(int val);
  private:
    QCheckBox *useExtents;
    QLineEdit *startX;
    QLineEdit *endX;
    QLineEdit *cellsX;
    QLineEdit *startY;
    QLineEdit *endY;
    QLineEdit *cellsY;
    QCheckBox *is3D;
    QLineEdit *startZ;
    QLineEdit *endZ;
    QLineEdit *cellsZ;
    QWidget      *variableType;
    QButtonGroup *variableTypeButtonGroup;
    QLabel *startXLabel;
    QLabel *endXLabel;
    QLabel *cellsXLabel;
    QLabel *startYLabel;
    QLabel *endYLabel;
    QLabel *cellsYLabel;
    QLabel *startZLabel;
    QLabel *endZLabel;
    QLabel *cellsZLabel;
    QLabel *variableTypeLabel;

    RemapAttributes *atts;
};



#endif
