// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtReflectFilter.h
// ************************************************************************* //

#ifndef AVT_Reflect_FILTER_H
#define AVT_Reflect_FILTER_H

#include <avtSIMODataTreeIterator.h>
#include <avtPluginFilter.h>

#include <ReflectAttributes.h>

class vtkDataArray;
class vtkDataSet;
class vtkPointSet;
class vtkRectilinearGrid;


// ****************************************************************************
//  Class: avtReflectFilter
//
//  Purpose:
//      A plugin operator for Reflect.
//
//  Programmer: childs -- generated by xml2info
//  Creation:   Thu Mar 7 10:35:24 PDT 2002
//
//  Modifications:
//
//    Hank Childs, Fri Sep  3 12:10:47 PDT 2010
//    Add Boolean to zero out velocities on the boundary.
//
//    Eric Brugger, Thu Jul 31 19:15:11 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
//    Alister Maguire, Tue Nov 15 11:51:26 PST 2016
//    Added ThreadSafe method.     
//
//    Alister Maguire, Tue Apr 10 13:22:11 PDT 2018
//    Added PlaneReflect for reflecting about an arbitrary plane, 
//    ghostsCreated to signify when ghost zones have been created, 
//    and changed names of previous reflect functions to AxisReflect*.
//
// ****************************************************************************

class avtReflectFilter : public virtual avtSIMODataTreeIterator,
                         public virtual avtPluginFilter
{
  public:
                         avtReflectFilter();
    virtual             ~avtReflectFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtReflectFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Reflecting the data"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    ReflectAttributes     atts;
    double                xReflect;
    double                yReflect;
    double                zReflect;
    bool                  zeroOutVelocitiesOnBoundary;
    bool                  ghostsCreated;

    virtual bool          ThreadSafe(void) { return(true); };
    virtual void          PreExecute(void);
    virtual void          PostExecute(void);
    virtual avtDataTree_p ExecuteDataTree(avtDataRepresentation *);
    virtual avtContract_p
                          ModifyContract(avtContract_p);
    virtual void          UpdateDataObjectInfo(void);

    vtkDataSet           *PlaneReflect(vtkDataSet *, bool);
    vtkDataSet           *AxisReflect(vtkDataSet *, int);
    vtkDataSet           *AxisReflectRectilinear(vtkRectilinearGrid *, int);
    vtkDataSet           *AxisReflectPointSet(vtkPointSet *, int);
    vtkDataArray         *ReflectDataArray(vtkDataArray *, double);
    void                  HasNeighbor(int, bool &, bool &, bool &);
};


#endif
