// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReflectPluginInfo.h
// ****************************************************************************

#ifndef REFLECT_PLUGIN_INFO_H
#define REFLECT_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class ReflectAttributes;

// ****************************************************************************
//  Class: ReflectPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an Reflect operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class ReflectGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class ReflectCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual ReflectGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class ReflectGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual ReflectCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class ReflectViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual ReflectCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static ReflectAttributes *defaultAtts;
    static ReflectAttributes *clientAtts;
};

class ReflectViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual ReflectViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class ReflectEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual ReflectViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class ReflectScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual ReflectCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
