// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ReflectCommonPluginInfo.C
// ****************************************************************************

#include <ReflectPluginInfo.h>
#include <ReflectAttributes.h>

// ****************************************************************************
//  Method: ReflectCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ReflectCommonPluginInfo::AllocAttributes()
{
    return new ReflectAttributes;
}

// ****************************************************************************
//  Method: ReflectCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Reflect attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ReflectCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ReflectAttributes *) to) = *((ReflectAttributes *) from);
}
