// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: RadialResampleCommonPluginInfo.C
// ****************************************************************************

#include <RadialResamplePluginInfo.h>
#include <RadialResampleAttributes.h>

// ****************************************************************************
//  Method: RadialResampleCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
RadialResampleCommonPluginInfo::AllocAttributes()
{
    return new RadialResampleAttributes;
}

// ****************************************************************************
//  Method: RadialResampleCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a RadialResample attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
RadialResampleCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((RadialResampleAttributes *) to) = *((RadialResampleAttributes *) from);
}
