// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#ifndef QVISPROJECTWINDOW_H
#define QVISPROJECTWINDOW_H

#include <QvisOperatorWindow.h>
#include <AttributeSubject.h>

class ProjectAttributes;
class QComboBox;

// ****************************************************************************
// Class: QvisProjectWindow
//
// Purpose:
//    Defines QvisProjectWindow class.
//
// Notes:      Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Jeremy Meredith, Thu Apr  1 14:47:27 EDT 2010
//   Made projection type a combo box since there are 6 of them now.
//   Adde dvector transform type.
//
//   
// ****************************************************************************

class QvisProjectWindow : public QvisOperatorWindow
{
    Q_OBJECT
  public:
    QvisProjectWindow(const int type,
                         ProjectAttributes *subj,
                         const QString &caption = QString::null,
                         const QString &shortName = QString::null,
                         QvisNotepadArea *notepad = 0);
    virtual ~QvisProjectWindow();
    virtual void CreateWindowContents();
  protected:
    void UpdateWindow(bool doAll);
    virtual void GetCurrentValues(int which_widget);
  private slots:
    void projectionTypeChanged(int val);
    void vectorMethodChanged(int);
  private:
    QComboBox    *projectionTypeCombo;
    QComboBox    *vectorMethodCombo;

    ProjectAttributes *atts;
};



#endif
