// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: ProjectCommonPluginInfo.C
// ****************************************************************************

#include <ProjectPluginInfo.h>
#include <ProjectAttributes.h>

// ****************************************************************************
//  Method: ProjectCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
ProjectCommonPluginInfo::AllocAttributes()
{
    return new ProjectAttributes;
}

// ****************************************************************************
//  Method: ProjectCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Project attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
ProjectCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((ProjectAttributes *) to) = *((ProjectAttributes *) from);
}
