// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyPoincareAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>
#include <ColorAttribute.h>

// ****************************************************************************
// Module: PyPoincareAttributes
//
// Purpose:
//   Attributes for the Poincare
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PoincareAttributes.
//
struct PoincareAttributesObject
{
    PyObject_HEAD
    PoincareAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPoincareAttributes(int);

std::string
PyPoincareAttributes_ToString(const PoincareAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    const char *opacityType_names = "Explicit, ColorTable";
    switch (atts->GetOpacityType())
    {
      case PoincareAttributes::Explicit:
          snprintf(tmpStr, 1000, "%sopacityType = %sExplicit  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ColorTable:
          snprintf(tmpStr, 1000, "%sopacityType = %sColorTable  # %s\n", prefix, prefix, opacityType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sopacity = %g\n", prefix, atts->GetOpacity());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sminPunctures = %d\n", prefix, atts->GetMinPunctures());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxPunctures = %d\n", prefix, atts->GetMaxPunctures());
    str += tmpStr;
    const char *puncturePlotType_names = "Single, Double";
    switch (atts->GetPuncturePlotType())
    {
      case PoincareAttributes::Single:
          snprintf(tmpStr, 1000, "%spuncturePlotType = %sSingle  # %s\n", prefix, prefix, puncturePlotType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Double:
          snprintf(tmpStr, 1000, "%spuncturePlotType = %sDouble  # %s\n", prefix, prefix, puncturePlotType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxSteps = %d\n", prefix, atts->GetMaxSteps());
    str += tmpStr;
    if(atts->GetTerminateByTime())
        snprintf(tmpStr, 1000, "%sterminateByTime = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sterminateByTime = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%stermTime = %g\n", prefix, atts->GetTermTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spuncturePeriodTolerance = %g\n", prefix, atts->GetPuncturePeriodTolerance());
    str += tmpStr;
    const char *puncturePlane_names = "Poloidal, Toroidal, Arbitrary";
    switch (atts->GetPuncturePlane())
    {
      case PoincareAttributes::Poloidal:
          snprintf(tmpStr, 1000, "%spuncturePlane = %sPoloidal  # %s\n", prefix, prefix, puncturePlane_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Toroidal:
          snprintf(tmpStr, 1000, "%spuncturePlane = %sToroidal  # %s\n", prefix, prefix, puncturePlane_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Arbitrary:
          snprintf(tmpStr, 1000, "%spuncturePlane = %sArbitrary  # %s\n", prefix, prefix, puncturePlane_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *sourceType_names = "SpecifiedPoint, PointList, SpecifiedLine";
    switch (atts->GetSourceType())
    {
      case PoincareAttributes::SpecifiedPoint:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedPoint  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PointList:
          snprintf(tmpStr, 1000, "%ssourceType = %sPointList  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SpecifiedLine:
          snprintf(tmpStr, 1000, "%ssourceType = %sSpecifiedLine  # %s\n", prefix, prefix, sourceType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    {   const double *pointSource = atts->GetPointSource();
        snprintf(tmpStr, 1000, "%spointSource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", pointSource[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const doubleVector &pointList = atts->GetPointList();
        snprintf(tmpStr, 1000, "%spointList = (", prefix);
        str += tmpStr;
        for(size_t i = 0; i < pointList.size(); ++i)
        {
            snprintf(tmpStr, 1000, "%g", pointList[i]);
            str += tmpStr;
            if(i < pointList.size() - 1)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineStart = atts->GetLineStart();
        snprintf(tmpStr, 1000, "%slineStart = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineStart[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *lineEnd = atts->GetLineEnd();
        snprintf(tmpStr, 1000, "%slineEnd = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", lineEnd[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    snprintf(tmpStr, 1000, "%spointDensity = %d\n", prefix, atts->GetPointDensity());
    str += tmpStr;
    const char *fieldType_names = "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
        "NektarPPField, NIMRODField";
    switch (atts->GetFieldType())
    {
      case PoincareAttributes::Default:
          snprintf(tmpStr, 1000, "%sfieldType = %sDefault  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::FlashField:
          snprintf(tmpStr, 1000, "%sfieldType = %sFlashField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::M3DC12DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC12DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::M3DC13DField:
          snprintf(tmpStr, 1000, "%sfieldType = %sM3DC13DField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Nek5000Field:
          snprintf(tmpStr, 1000, "%sfieldType = %sNek5000Field  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::NektarPPField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNektarPPField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::NIMRODField:
          snprintf(tmpStr, 1000, "%sfieldType = %sNIMRODField  # %s\n", prefix, prefix, fieldType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetForceNodeCenteredData())
        snprintf(tmpStr, 1000, "%sforceNodeCenteredData = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sforceNodeCenteredData = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sfieldConstant = %g\n", prefix, atts->GetFieldConstant());
    str += tmpStr;
    {   const double *velocitySource = atts->GetVelocitySource();
        snprintf(tmpStr, 1000, "%svelocitySource = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", velocitySource[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    const char *integrationType_names = "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
        "M3DC12DIntegrator";
    switch (atts->GetIntegrationType())
    {
      case PoincareAttributes::Euler:
          snprintf(tmpStr, 1000, "%sintegrationType = %sEuler  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Leapfrog:
          snprintf(tmpStr, 1000, "%sintegrationType = %sLeapfrog  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::DormandPrince:
          snprintf(tmpStr, 1000, "%sintegrationType = %sDormandPrince  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::AdamsBashforth:
          snprintf(tmpStr, 1000, "%sintegrationType = %sAdamsBashforth  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::RK4:
          snprintf(tmpStr, 1000, "%sintegrationType = %sRK4  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::M3DC12DIntegrator:
          snprintf(tmpStr, 1000, "%sintegrationType = %sM3DC12DIntegrator  # %s\n", prefix, prefix, integrationType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *coordinateSystem_names = "Cartesian, Cylindrical";
    switch (atts->GetCoordinateSystem())
    {
      case PoincareAttributes::Cartesian:
          snprintf(tmpStr, 1000, "%scoordinateSystem = %sCartesian  # %s\n", prefix, prefix, coordinateSystem_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Cylindrical:
          snprintf(tmpStr, 1000, "%scoordinateSystem = %sCylindrical  # %s\n", prefix, prefix, coordinateSystem_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxStepLength = %g\n", prefix, atts->GetMaxStepLength());
    str += tmpStr;
    if(atts->GetLimitMaximumTimestep())
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%slimitMaximumTimestep = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxTimeStep = %g\n", prefix, atts->GetMaxTimeStep());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srelTol = %g\n", prefix, atts->GetRelTol());
    str += tmpStr;
    const char *absTolSizeType_names = "Absolute, FractionOfBBox";
    switch (atts->GetAbsTolSizeType())
    {
      case PoincareAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sAbsolute  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::FractionOfBBox:
          snprintf(tmpStr, 1000, "%sabsTolSizeType = %sFractionOfBBox  # %s\n", prefix, prefix, absTolSizeType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%sabsTolAbsolute = %g\n", prefix, atts->GetAbsTolAbsolute());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sabsTolBBox = %g\n", prefix, atts->GetAbsTolBBox());
    str += tmpStr;
    const char *analysis_names = "None, Normal";
    switch (atts->GetAnalysis())
    {
      case PoincareAttributes::None:
          snprintf(tmpStr, 1000, "%sanalysis = %sNone  # %s\n", prefix, prefix, analysis_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Normal:
          snprintf(tmpStr, 1000, "%sanalysis = %sNormal  # %s\n", prefix, prefix, analysis_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaximumToroidalWinding = %d\n", prefix, atts->GetMaximumToroidalWinding());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%soverrideToroidalWinding = %d\n", prefix, atts->GetOverrideToroidalWinding());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%soverridePoloidalWinding = %d\n", prefix, atts->GetOverridePoloidalWinding());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%swindingPairConfidence = %g\n", prefix, atts->GetWindingPairConfidence());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%srationalSurfaceFactor = %g\n", prefix, atts->GetRationalSurfaceFactor());
    str += tmpStr;
    const char *overlaps_names = "Raw, Remove, Merge, Smooth";
    switch (atts->GetOverlaps())
    {
      case PoincareAttributes::Raw:
          snprintf(tmpStr, 1000, "%soverlaps = %sRaw  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Remove:
          snprintf(tmpStr, 1000, "%soverlaps = %sRemove  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Merge:
          snprintf(tmpStr, 1000, "%soverlaps = %sMerge  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Smooth:
          snprintf(tmpStr, 1000, "%soverlaps = %sSmooth  # %s\n", prefix, prefix, overlaps_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *meshType_names = "Curves, Surfaces";
    switch (atts->GetMeshType())
    {
      case PoincareAttributes::Curves:
          snprintf(tmpStr, 1000, "%smeshType = %sCurves  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::Surfaces:
          snprintf(tmpStr, 1000, "%smeshType = %sSurfaces  # %s\n", prefix, prefix, meshType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%snumberPlanes = %d\n", prefix, atts->GetNumberPlanes());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%ssinglePlane = %g\n", prefix, atts->GetSinglePlane());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smin = %g\n", prefix, atts->GetMin());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smax = %g\n", prefix, atts->GetMax());
    str += tmpStr;
    if(atts->GetMinFlag())
        snprintf(tmpStr, 1000, "%sminFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sminFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetMaxFlag())
        snprintf(tmpStr, 1000, "%smaxFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%smaxFlag = 0\n", prefix);
    str += tmpStr;
    const char *colorType_names = "ColorBySingleColor, ColorByColorTable";
    switch (atts->GetColorType())
    {
      case PoincareAttributes::ColorBySingleColor:
          snprintf(tmpStr, 1000, "%scolorType = %sColorBySingleColor  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ColorByColorTable:
          snprintf(tmpStr, 1000, "%scolorType = %sColorByColorTable  # %s\n", prefix, prefix, colorType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const unsigned char *singleColor = atts->GetSingleColor().GetColor();
    snprintf(tmpStr, 1000, "%ssingleColor = (%d, %d, %d, %d)\n", prefix, int(singleColor[0]), int(singleColor[1]), int(singleColor[2]), int(singleColor[3]));
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scolorTableName = \"%s\"\n", prefix, atts->GetColorTableName().c_str());
    str += tmpStr;
    const char *dataValue_names = "Solid, SafetyFactorQ, SafetyFactorP, SafetyFactorQ_NotP, SafetyFactorP_NotQ, "
        "ToroidalWindings, PoloidalWindingsQ, PoloidalWindingsP, FieldlineOrder, "
        "PointOrder, PlaneOrder, WindingGroupOrder, WindingPointOrder, "
        "WindingPointOrderModulo";
    switch (atts->GetDataValue())
    {
      case PoincareAttributes::Solid:
          snprintf(tmpStr, 1000, "%sdataValue = %sSolid  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SafetyFactorQ:
          snprintf(tmpStr, 1000, "%sdataValue = %sSafetyFactorQ  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SafetyFactorP:
          snprintf(tmpStr, 1000, "%sdataValue = %sSafetyFactorP  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SafetyFactorQ_NotP:
          snprintf(tmpStr, 1000, "%sdataValue = %sSafetyFactorQ_NotP  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::SafetyFactorP_NotQ:
          snprintf(tmpStr, 1000, "%sdataValue = %sSafetyFactorP_NotQ  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ToroidalWindings:
          snprintf(tmpStr, 1000, "%sdataValue = %sToroidalWindings  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PoloidalWindingsQ:
          snprintf(tmpStr, 1000, "%sdataValue = %sPoloidalWindingsQ  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PoloidalWindingsP:
          snprintf(tmpStr, 1000, "%sdataValue = %sPoloidalWindingsP  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::FieldlineOrder:
          snprintf(tmpStr, 1000, "%sdataValue = %sFieldlineOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PointOrder:
          snprintf(tmpStr, 1000, "%sdataValue = %sPointOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::PlaneOrder:
          snprintf(tmpStr, 1000, "%sdataValue = %sPlaneOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingGroupOrder:
          snprintf(tmpStr, 1000, "%sdataValue = %sWindingGroupOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingPointOrder:
          snprintf(tmpStr, 1000, "%sdataValue = %sWindingPointOrder  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      case PoincareAttributes::WindingPointOrderModulo:
          snprintf(tmpStr, 1000, "%sdataValue = %sWindingPointOrderModulo  # %s\n", prefix, prefix, dataValue_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetShowRationalSurfaces())
        snprintf(tmpStr, 1000, "%sshowRationalSurfaces = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowRationalSurfaces = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sRationalSurfaceMaxIterations = %d\n", prefix, atts->GetRationalSurfaceMaxIterations());
    str += tmpStr;
    if(atts->GetShowOPoints())
        snprintf(tmpStr, 1000, "%sshowOPoints = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowOPoints = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sOPointMaxIterations = %d\n", prefix, atts->GetOPointMaxIterations());
    str += tmpStr;
    if(atts->GetShowXPoints())
        snprintf(tmpStr, 1000, "%sshowXPoints = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowXPoints = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sXPointMaxIterations = %d\n", prefix, atts->GetXPointMaxIterations());
    str += tmpStr;
    if(atts->GetPerformOLineAnalysis())
        snprintf(tmpStr, 1000, "%sperformOLineAnalysis = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sperformOLineAnalysis = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sOLineToroidalWinding = %d\n", prefix, atts->GetOLineToroidalWinding());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sOLineAxisFileName = \"%s\"\n", prefix, atts->GetOLineAxisFileName().c_str());
    str += tmpStr;
    if(atts->GetShowChaotic())
        snprintf(tmpStr, 1000, "%sshowChaotic = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowChaotic = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowIslands())
        snprintf(tmpStr, 1000, "%sshowIslands = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowIslands = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSummaryFlag())
        snprintf(tmpStr, 1000, "%sSummaryFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sSummaryFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetVerboseFlag())
        snprintf(tmpStr, 1000, "%sverboseFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sverboseFlag = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShow1DPlots())
        snprintf(tmpStr, 1000, "%sshow1DPlots = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshow1DPlots = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowLines())
        snprintf(tmpStr, 1000, "%sshowLines = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowLines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowPoints())
        snprintf(tmpStr, 1000, "%sshowPoints = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowPoints = 0\n", prefix);
    str += tmpStr;
    const char *parallelizationAlgorithmType_names = "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects";
    switch (atts->GetParallelizationAlgorithmType())
    {
      case PoincareAttributes::LoadOnDemand:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sLoadOnDemand  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::ParallelStaticDomains:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sParallelStaticDomains  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::MasterSlave:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sMasterSlave  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      case PoincareAttributes::VisItSelects:
          snprintf(tmpStr, 1000, "%sparallelizationAlgorithmType = %sVisItSelects  # %s\n", prefix, prefix, parallelizationAlgorithmType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%smaxProcessCount = %d\n", prefix, atts->GetMaxProcessCount());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%smaxDomainCacheSize = %d\n", prefix, atts->GetMaxDomainCacheSize());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sworkGroupSize = %d\n", prefix, atts->GetWorkGroupSize());
    str += tmpStr;
    if(atts->GetPathlines())
        snprintf(tmpStr, 1000, "%spathlines = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlines = 0\n", prefix);
    str += tmpStr;
    if(atts->GetPathlinesOverrideStartingTimeFlag())
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTimeFlag = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesOverrideStartingTime = %g\n", prefix, atts->GetPathlinesOverrideStartingTime());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%spathlinesPeriod = %g\n", prefix, atts->GetPathlinesPeriod());
    str += tmpStr;
    const char *pathlinesCMFE_names = "CONN_CMFE, POS_CMFE";
    switch (atts->GetPathlinesCMFE())
    {
      case PoincareAttributes::CONN_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sCONN_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      case PoincareAttributes::POS_CMFE:
          snprintf(tmpStr, 1000, "%spathlinesCMFE = %sPOS_CMFE  # %s\n", prefix, prefix, pathlinesCMFE_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    if(atts->GetIssueTerminationWarnings())
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueTerminationWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStepsizeWarnings())
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStepsizeWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueStiffnessWarnings())
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueStiffnessWarnings = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIssueCriticalPointsWarnings())
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sissueCriticalPointsWarnings = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%scriticalPointThreshold = %g\n", prefix, atts->GetCriticalPointThreshold());
    str += tmpStr;
    return str;
}

static PyObject *
PoincareAttributes_Notify(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_SetOpacityType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the opacityType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetOpacityType(PoincareAttributes::Opacity(ival));
    else
    {
        fprintf(stderr, "An invalid opacityType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Explicit, ColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOpacityType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOpacityType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOpacity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the opacity in the object.
    obj->data->SetOpacity(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOpacity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetOpacity());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMinPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minPunctures in the object.
    obj->data->SetMinPunctures((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMinPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMinPunctures()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxPunctures in the object.
    obj->data->SetMaxPunctures((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxPunctures(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxPunctures()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPuncturePlotType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the puncturePlotType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPuncturePlotType(PoincareAttributes::PuncturePlotType(ival));
    else
    {
        fprintf(stderr, "An invalid puncturePlotType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Single, Double.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPuncturePlotType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPuncturePlotType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxSteps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxSteps in the object.
    obj->data->SetMaxSteps((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxSteps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxSteps()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetTerminateByTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the terminateByTime in the object.
    obj->data->SetTerminateByTime(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetTerminateByTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetTerminateByTime()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetTermTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the termTime in the object.
    obj->data->SetTermTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetTermTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetTermTime());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPuncturePeriodTolerance(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the puncturePeriodTolerance in the object.
    obj->data->SetPuncturePeriodTolerance(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPuncturePeriodTolerance(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPuncturePeriodTolerance());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPuncturePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the puncturePlane in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetPuncturePlane(PoincareAttributes::PuncturePlaneType(ival));
    else
    {
        fprintf(stderr, "An invalid puncturePlane value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "Poloidal, Toroidal, Arbitrary.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPuncturePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPuncturePlane()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSourceType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the sourceType in the object.
    if(ival >= 0 && ival < 3)
        obj->data->SetSourceType(PoincareAttributes::SourceType(ival));
    else
    {
        fprintf(stderr, "An invalid sourceType value was given. "
                        "Valid values are in the range of [0,2]. "
                        "You can also use the following names: "
                        "SpecifiedPoint, PointList, SpecifiedLine.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSourceType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetSourceType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPointSource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetPointSource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the pointSource in the object as modified.
    obj->data->SelectPointSource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPointSource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointSource.
    PyObject *retval = PyTuple_New(3);
    const double *pointSource = obj->data->GetPointSource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointSource[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPointList(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    doubleVector  &vec = obj->data->GetPointList();
    PyObject     *tuple;
    if(!PyArg_ParseTuple(args, "O", &tuple))
        return NULL;

    if(PyTuple_Check(tuple))
    {
        vec.resize(PyTuple_Size(tuple));
        for(int i = 0; i < PyTuple_Size(tuple); ++i)
        {
            PyObject *item = PyTuple_GET_ITEM(tuple, i);
            if(PyFloat_Check(item))
                vec[i] = PyFloat_AS_DOUBLE(item);
            else if(PyInt_Check(item))
                vec[i] = double(PyInt_AS_LONG(item));
            else if(PyLong_Check(item))
                vec[i] = PyLong_AsDouble(item);
            else
                vec[i] = 0.;
        }
    }
    else if(PyFloat_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyFloat_AS_DOUBLE(tuple);
    }
    else if(PyInt_Check(tuple))
    {
        vec.resize(1);
        vec[0] = double(PyInt_AS_LONG(tuple));
    }
    else if(PyLong_Check(tuple))
    {
        vec.resize(1);
        vec[0] = PyLong_AsDouble(tuple);
    }
    else
        return NULL;

    // Mark the pointList in the object as modified.
    obj->data->SelectPointList();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPointList(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the pointList.
    const doubleVector &pointList = obj->data->GetPointList();
    PyObject *retval = PyTuple_New(pointList.size());
    for(size_t i = 0; i < pointList.size(); ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(pointList[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLineStart(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetLineStart();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineStart in the object as modified.
    obj->data->SelectLineStart();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLineStart(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineStart.
    PyObject *retval = PyTuple_New(3);
    const double *lineStart = obj->data->GetLineStart();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineStart[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLineEnd(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetLineEnd();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the lineEnd in the object as modified.
    obj->data->SelectLineEnd();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLineEnd(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the lineEnd.
    PyObject *retval = PyTuple_New(3);
    const double *lineEnd = obj->data->GetLineEnd();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(lineEnd[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPointDensity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pointDensity in the object.
    obj->data->SetPointDensity((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPointDensity(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPointDensity()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetFieldType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the fieldType in the object.
    if(ival >= 0 && ival < 7)
        obj->data->SetFieldType(PoincareAttributes::FieldType(ival));
    else
    {
        fprintf(stderr, "An invalid fieldType value was given. "
                        "Valid values are in the range of [0,6]. "
                        "You can also use the following names: "
                        "Default, FlashField, M3DC12DField, M3DC13DField, Nek5000Field, "
                        "NektarPPField, NIMRODField.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetFieldType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetFieldType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetForceNodeCenteredData(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the forceNodeCenteredData in the object.
    obj->data->SetForceNodeCenteredData(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetForceNodeCenteredData(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetForceNodeCenteredData()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetFieldConstant(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the fieldConstant in the object.
    obj->data->SetFieldConstant(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetFieldConstant(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetFieldConstant());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetVelocitySource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double *dvals = obj->data->GetVelocitySource();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the velocitySource in the object as modified.
    obj->data->SelectVelocitySource();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetVelocitySource(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the velocitySource.
    PyObject *retval = PyTuple_New(3);
    const double *velocitySource = obj->data->GetVelocitySource();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(velocitySource[i]));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIntegrationType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the integrationType in the object.
    if(ival >= 0 && ival < 6)
        obj->data->SetIntegrationType(PoincareAttributes::IntegrationType(ival));
    else
    {
        fprintf(stderr, "An invalid integrationType value was given. "
                        "Valid values are in the range of [0,5]. "
                        "You can also use the following names: "
                        "Euler, Leapfrog, DormandPrince, AdamsBashforth, RK4, "
                        "M3DC12DIntegrator.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIntegrationType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetIntegrationType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetCoordinateSystem(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the coordinateSystem in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetCoordinateSystem(PoincareAttributes::CoordinateSystem(ival));
    else
    {
        fprintf(stderr, "An invalid coordinateSystem value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Cartesian, Cylindrical.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetCoordinateSystem(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetCoordinateSystem()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxStepLength(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxStepLength in the object.
    obj->data->SetMaxStepLength(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxStepLength(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxStepLength());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the limitMaximumTimestep in the object.
    obj->data->SetLimitMaximumTimestep(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetLimitMaximumTimestep(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetLimitMaximumTimestep()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxTimeStep(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the maxTimeStep in the object.
    obj->data->SetMaxTimeStep(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxTimeStep(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMaxTimeStep());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetRelTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the relTol in the object.
    obj->data->SetRelTol(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetRelTol(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRelTol());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAbsTolSizeType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the absTolSizeType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAbsTolSizeType(PoincareAttributes::SizeType(ival));
    else
    {
        fprintf(stderr, "An invalid absTolSizeType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, FractionOfBBox.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAbsTolSizeType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAbsTolSizeType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolAbsolute in the object.
    obj->data->SetAbsTolAbsolute(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAbsTolAbsolute(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolAbsolute());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAbsTolBBox(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the absTolBBox in the object.
    obj->data->SetAbsTolBBox(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAbsTolBBox(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetAbsTolBBox());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetAnalysis(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the analysis in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetAnalysis(PoincareAttributes::AnalysisType(ival));
    else
    {
        fprintf(stderr, "An invalid analysis value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "None, Normal.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetAnalysis(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetAnalysis()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaximumToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maximumToroidalWinding in the object.
    obj->data->SetMaximumToroidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaximumToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaximumToroidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOverrideToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overrideToroidalWinding in the object.
    obj->data->SetOverrideToroidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOverrideToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOverrideToroidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOverridePoloidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overridePoloidalWinding in the object.
    obj->data->SetOverridePoloidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOverridePoloidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOverridePoloidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetWindingPairConfidence(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the windingPairConfidence in the object.
    obj->data->SetWindingPairConfidence(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetWindingPairConfidence(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetWindingPairConfidence());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetRationalSurfaceFactor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the rationalSurfaceFactor in the object.
    obj->data->SetRationalSurfaceFactor(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetRationalSurfaceFactor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetRationalSurfaceFactor());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOverlaps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the overlaps in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetOverlaps(PoincareAttributes::OverlapType(ival));
    else
    {
        fprintf(stderr, "An invalid overlaps value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "Raw, Remove, Merge, Smooth.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOverlaps(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOverlaps()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMeshType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the meshType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetMeshType(PoincareAttributes::ShowMeshType(ival));
    else
    {
        fprintf(stderr, "An invalid meshType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Curves, Surfaces.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMeshType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMeshType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetNumberPlanes(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberPlanes in the object.
    obj->data->SetNumberPlanes((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetNumberPlanes(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberPlanes()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSinglePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the singlePlane in the object.
    obj->data->SetSinglePlane(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSinglePlane(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetSinglePlane());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMin(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the min in the object.
    obj->data->SetMin(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMin(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMin());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMax(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the max in the object.
    obj->data->SetMax(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMax(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetMax());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMinFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the minFlag in the object.
    obj->data->SetMinFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMinFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMinFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxFlag in the object.
    obj->data->SetMaxFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetMaxFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetColorType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the colorType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetColorType(PoincareAttributes::ColoringMethod(ival));
    else
    {
        fprintf(stderr, "An invalid colorType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "ColorBySingleColor, ColorByColorTable.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetColorType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetColorType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSingleColor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int c[4];
    if(!PyArg_ParseTuple(args, "iiii", &c[0], &c[1], &c[2], &c[3]))
    {
        c[3] = 255;
        if(!PyArg_ParseTuple(args, "iii", &c[0], &c[1], &c[2]))
        {
            double dr, dg, db, da;
            if(PyArg_ParseTuple(args, "dddd", &dr, &dg, &db, &da))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = int(da);
            }
            else if(PyArg_ParseTuple(args, "ddd", &dr, &dg, &db))
            {
                c[0] = int(dr);
                c[1] = int(dg);
                c[2] = int(db);
                c[3] = 255;
            }
            else
            {
                PyObject *tuple = NULL;
                if(!PyArg_ParseTuple(args, "O", &tuple))
                    return NULL;

                if(!PyTuple_Check(tuple))
                    return NULL;

                // Make sure that the tuple is the right size.
                if(PyTuple_Size(tuple) < 3 || PyTuple_Size(tuple) > 4)
                    return NULL;

                // Make sure that all elements in the tuple are ints.
                for(int i = 0; i < PyTuple_Size(tuple); ++i)
                {
                    PyObject *item = PyTuple_GET_ITEM(tuple, i);
                    if(PyInt_Check(item))
                        c[i] = int(PyInt_AS_LONG(PyTuple_GET_ITEM(tuple, i)));
                    else if(PyFloat_Check(item))
                        c[i] = int(PyFloat_AS_DOUBLE(PyTuple_GET_ITEM(tuple, i)));
                    else
                        return NULL;
                }
            }
        }
        PyErr_Clear();
    }

    // Set the singleColor in the object.
    ColorAttribute ca(c[0], c[1], c[2], c[3]);
    obj->data->SetSingleColor(ca);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSingleColor(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the singleColor.
    PyObject *retval = PyTuple_New(4);
    const unsigned char *singleColor = obj->data->GetSingleColor().GetColor();
    PyTuple_SET_ITEM(retval, 0, PyInt_FromLong(long(singleColor[0])));
    PyTuple_SET_ITEM(retval, 1, PyInt_FromLong(long(singleColor[1])));
    PyTuple_SET_ITEM(retval, 2, PyInt_FromLong(long(singleColor[2])));
    PyTuple_SET_ITEM(retval, 3, PyInt_FromLong(long(singleColor[3])));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetColorTableName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the colorTableName in the object.
    obj->data->SetColorTableName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetColorTableName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetColorTableName().c_str());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetDataValue(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the dataValue in the object.
    if(ival >= 0 && ival < 14)
        obj->data->SetDataValue(PoincareAttributes::DataValue(ival));
    else
    {
        fprintf(stderr, "An invalid dataValue value was given. "
                        "Valid values are in the range of [0,13]. "
                        "You can also use the following names: "
                        "Solid, SafetyFactorQ, SafetyFactorP, SafetyFactorQ_NotP, SafetyFactorP_NotQ, "
                        "ToroidalWindings, PoloidalWindingsQ, PoloidalWindingsP, FieldlineOrder, "
                        "PointOrder, PlaneOrder, WindingGroupOrder, WindingPointOrder, "
                        "WindingPointOrderModulo.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetDataValue(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetDataValue()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowRationalSurfaces(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showRationalSurfaces in the object.
    obj->data->SetShowRationalSurfaces(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowRationalSurfaces(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowRationalSurfaces()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetRationalSurfaceMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the RationalSurfaceMaxIterations in the object.
    obj->data->SetRationalSurfaceMaxIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetRationalSurfaceMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetRationalSurfaceMaxIterations()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowOPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showOPoints in the object.
    obj->data->SetShowOPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowOPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowOPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOPointMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the OPointMaxIterations in the object.
    obj->data->SetOPointMaxIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOPointMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOPointMaxIterations()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowXPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showXPoints in the object.
    obj->data->SetShowXPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowXPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowXPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetXPointMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the XPointMaxIterations in the object.
    obj->data->SetXPointMaxIterations((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetXPointMaxIterations(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetXPointMaxIterations()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPerformOLineAnalysis(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the performOLineAnalysis in the object.
    obj->data->SetPerformOLineAnalysis(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPerformOLineAnalysis(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPerformOLineAnalysis()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOLineToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the OLineToroidalWinding in the object.
    obj->data->SetOLineToroidalWinding((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOLineToroidalWinding(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetOLineToroidalWinding()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetOLineAxisFileName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the OLineAxisFileName in the object.
    obj->data->SetOLineAxisFileName(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetOLineAxisFileName(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetOLineAxisFileName().c_str());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowChaotic(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showChaotic in the object.
    obj->data->SetShowChaotic(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowChaotic(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowChaotic()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowIslands(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showIslands in the object.
    obj->data->SetShowIslands(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowIslands(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowIslands()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetSummaryFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the SummaryFlag in the object.
    obj->data->SetSummaryFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetSummaryFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSummaryFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetVerboseFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the verboseFlag in the object.
    obj->data->SetVerboseFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetVerboseFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetVerboseFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShow1DPlots(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the show1DPlots in the object.
    obj->data->SetShow1DPlots(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShow1DPlots(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShow1DPlots()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowLines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showLines in the object.
    obj->data->SetShowLines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowLines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowLines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the parallelizationAlgorithmType in the object.
    if(ival >= 0 && ival < 4)
        obj->data->SetParallelizationAlgorithmType(PoincareAttributes::ParallelizationAlgorithmType(ival));
    else
    {
        fprintf(stderr, "An invalid parallelizationAlgorithmType value was given. "
                        "Valid values are in the range of [0,3]. "
                        "You can also use the following names: "
                        "LoadOnDemand, ParallelStaticDomains, MasterSlave, VisItSelects.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetParallelizationAlgorithmType(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetParallelizationAlgorithmType()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxProcessCount(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxProcessCount in the object.
    obj->data->SetMaxProcessCount((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxProcessCount(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxProcessCount()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the maxDomainCacheSize in the object.
    obj->data->SetMaxDomainCacheSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetMaxDomainCacheSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetMaxDomainCacheSize()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetWorkGroupSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the workGroupSize in the object.
    obj->data->SetWorkGroupSize((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetWorkGroupSize(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetWorkGroupSize()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPathlines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlines in the object.
    obj->data->SetPathlines(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPathlines(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlines()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesOverrideStartingTimeFlag in the object.
    obj->data->SetPathlinesOverrideStartingTimeFlag(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPathlinesOverrideStartingTimeFlag(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetPathlinesOverrideStartingTimeFlag()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesOverrideStartingTime in the object.
    obj->data->SetPathlinesOverrideStartingTime(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPathlinesOverrideStartingTime(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesOverrideStartingTime());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPathlinesPeriod(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the pathlinesPeriod in the object.
    obj->data->SetPathlinesPeriod(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPathlinesPeriod(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetPathlinesPeriod());
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetPathlinesCMFE(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the pathlinesCMFE in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetPathlinesCMFE(PoincareAttributes::PathlinesCMFE(ival));
    else
    {
        fprintf(stderr, "An invalid pathlinesCMFE value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "CONN_CMFE, POS_CMFE.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetPathlinesCMFE(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetPathlinesCMFE()));
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueTerminationWarnings in the object.
    obj->data->SetIssueTerminationWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIssueTerminationWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueTerminationWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStepsizeWarnings in the object.
    obj->data->SetIssueStepsizeWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIssueStepsizeWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStepsizeWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueStiffnessWarnings in the object.
    obj->data->SetIssueStiffnessWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIssueStiffnessWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueStiffnessWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the issueCriticalPointsWarnings in the object.
    obj->data->SetIssueCriticalPointsWarnings(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetIssueCriticalPointsWarnings(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIssueCriticalPointsWarnings()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PoincareAttributes_SetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;

    double dval;
    if(!PyArg_ParseTuple(args, "d", &dval))
        return NULL;

    // Set the criticalPointThreshold in the object.
    obj->data->SetCriticalPointThreshold(dval);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PoincareAttributes_GetCriticalPointThreshold(PyObject *self, PyObject *args)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)self;
    PyObject *retval = PyFloat_FromDouble(obj->data->GetCriticalPointThreshold());
    return retval;
}



PyMethodDef PyPoincareAttributes_methods[POINCAREATTRIBUTES_NMETH] = {
    {"Notify", PoincareAttributes_Notify, METH_VARARGS},
    {"SetOpacityType", PoincareAttributes_SetOpacityType, METH_VARARGS},
    {"GetOpacityType", PoincareAttributes_GetOpacityType, METH_VARARGS},
    {"SetOpacity", PoincareAttributes_SetOpacity, METH_VARARGS},
    {"GetOpacity", PoincareAttributes_GetOpacity, METH_VARARGS},
    {"SetMinPunctures", PoincareAttributes_SetMinPunctures, METH_VARARGS},
    {"GetMinPunctures", PoincareAttributes_GetMinPunctures, METH_VARARGS},
    {"SetMaxPunctures", PoincareAttributes_SetMaxPunctures, METH_VARARGS},
    {"GetMaxPunctures", PoincareAttributes_GetMaxPunctures, METH_VARARGS},
    {"SetPuncturePlotType", PoincareAttributes_SetPuncturePlotType, METH_VARARGS},
    {"GetPuncturePlotType", PoincareAttributes_GetPuncturePlotType, METH_VARARGS},
    {"SetMaxSteps", PoincareAttributes_SetMaxSteps, METH_VARARGS},
    {"GetMaxSteps", PoincareAttributes_GetMaxSteps, METH_VARARGS},
    {"SetTerminateByTime", PoincareAttributes_SetTerminateByTime, METH_VARARGS},
    {"GetTerminateByTime", PoincareAttributes_GetTerminateByTime, METH_VARARGS},
    {"SetTermTime", PoincareAttributes_SetTermTime, METH_VARARGS},
    {"GetTermTime", PoincareAttributes_GetTermTime, METH_VARARGS},
    {"SetPuncturePeriodTolerance", PoincareAttributes_SetPuncturePeriodTolerance, METH_VARARGS},
    {"GetPuncturePeriodTolerance", PoincareAttributes_GetPuncturePeriodTolerance, METH_VARARGS},
    {"SetPuncturePlane", PoincareAttributes_SetPuncturePlane, METH_VARARGS},
    {"GetPuncturePlane", PoincareAttributes_GetPuncturePlane, METH_VARARGS},
    {"SetSourceType", PoincareAttributes_SetSourceType, METH_VARARGS},
    {"GetSourceType", PoincareAttributes_GetSourceType, METH_VARARGS},
    {"SetPointSource", PoincareAttributes_SetPointSource, METH_VARARGS},
    {"GetPointSource", PoincareAttributes_GetPointSource, METH_VARARGS},
    {"SetPointList", PoincareAttributes_SetPointList, METH_VARARGS},
    {"GetPointList", PoincareAttributes_GetPointList, METH_VARARGS},
    {"SetLineStart", PoincareAttributes_SetLineStart, METH_VARARGS},
    {"GetLineStart", PoincareAttributes_GetLineStart, METH_VARARGS},
    {"SetLineEnd", PoincareAttributes_SetLineEnd, METH_VARARGS},
    {"GetLineEnd", PoincareAttributes_GetLineEnd, METH_VARARGS},
    {"SetPointDensity", PoincareAttributes_SetPointDensity, METH_VARARGS},
    {"GetPointDensity", PoincareAttributes_GetPointDensity, METH_VARARGS},
    {"SetFieldType", PoincareAttributes_SetFieldType, METH_VARARGS},
    {"GetFieldType", PoincareAttributes_GetFieldType, METH_VARARGS},
    {"SetForceNodeCenteredData", PoincareAttributes_SetForceNodeCenteredData, METH_VARARGS},
    {"GetForceNodeCenteredData", PoincareAttributes_GetForceNodeCenteredData, METH_VARARGS},
    {"SetFieldConstant", PoincareAttributes_SetFieldConstant, METH_VARARGS},
    {"GetFieldConstant", PoincareAttributes_GetFieldConstant, METH_VARARGS},
    {"SetVelocitySource", PoincareAttributes_SetVelocitySource, METH_VARARGS},
    {"GetVelocitySource", PoincareAttributes_GetVelocitySource, METH_VARARGS},
    {"SetIntegrationType", PoincareAttributes_SetIntegrationType, METH_VARARGS},
    {"GetIntegrationType", PoincareAttributes_GetIntegrationType, METH_VARARGS},
    {"SetCoordinateSystem", PoincareAttributes_SetCoordinateSystem, METH_VARARGS},
    {"GetCoordinateSystem", PoincareAttributes_GetCoordinateSystem, METH_VARARGS},
    {"SetMaxStepLength", PoincareAttributes_SetMaxStepLength, METH_VARARGS},
    {"GetMaxStepLength", PoincareAttributes_GetMaxStepLength, METH_VARARGS},
    {"SetLimitMaximumTimestep", PoincareAttributes_SetLimitMaximumTimestep, METH_VARARGS},
    {"GetLimitMaximumTimestep", PoincareAttributes_GetLimitMaximumTimestep, METH_VARARGS},
    {"SetMaxTimeStep", PoincareAttributes_SetMaxTimeStep, METH_VARARGS},
    {"GetMaxTimeStep", PoincareAttributes_GetMaxTimeStep, METH_VARARGS},
    {"SetRelTol", PoincareAttributes_SetRelTol, METH_VARARGS},
    {"GetRelTol", PoincareAttributes_GetRelTol, METH_VARARGS},
    {"SetAbsTolSizeType", PoincareAttributes_SetAbsTolSizeType, METH_VARARGS},
    {"GetAbsTolSizeType", PoincareAttributes_GetAbsTolSizeType, METH_VARARGS},
    {"SetAbsTolAbsolute", PoincareAttributes_SetAbsTolAbsolute, METH_VARARGS},
    {"GetAbsTolAbsolute", PoincareAttributes_GetAbsTolAbsolute, METH_VARARGS},
    {"SetAbsTolBBox", PoincareAttributes_SetAbsTolBBox, METH_VARARGS},
    {"GetAbsTolBBox", PoincareAttributes_GetAbsTolBBox, METH_VARARGS},
    {"SetAnalysis", PoincareAttributes_SetAnalysis, METH_VARARGS},
    {"GetAnalysis", PoincareAttributes_GetAnalysis, METH_VARARGS},
    {"SetMaximumToroidalWinding", PoincareAttributes_SetMaximumToroidalWinding, METH_VARARGS},
    {"GetMaximumToroidalWinding", PoincareAttributes_GetMaximumToroidalWinding, METH_VARARGS},
    {"SetOverrideToroidalWinding", PoincareAttributes_SetOverrideToroidalWinding, METH_VARARGS},
    {"GetOverrideToroidalWinding", PoincareAttributes_GetOverrideToroidalWinding, METH_VARARGS},
    {"SetOverridePoloidalWinding", PoincareAttributes_SetOverridePoloidalWinding, METH_VARARGS},
    {"GetOverridePoloidalWinding", PoincareAttributes_GetOverridePoloidalWinding, METH_VARARGS},
    {"SetWindingPairConfidence", PoincareAttributes_SetWindingPairConfidence, METH_VARARGS},
    {"GetWindingPairConfidence", PoincareAttributes_GetWindingPairConfidence, METH_VARARGS},
    {"SetRationalSurfaceFactor", PoincareAttributes_SetRationalSurfaceFactor, METH_VARARGS},
    {"GetRationalSurfaceFactor", PoincareAttributes_GetRationalSurfaceFactor, METH_VARARGS},
    {"SetOverlaps", PoincareAttributes_SetOverlaps, METH_VARARGS},
    {"GetOverlaps", PoincareAttributes_GetOverlaps, METH_VARARGS},
    {"SetMeshType", PoincareAttributes_SetMeshType, METH_VARARGS},
    {"GetMeshType", PoincareAttributes_GetMeshType, METH_VARARGS},
    {"SetNumberPlanes", PoincareAttributes_SetNumberPlanes, METH_VARARGS},
    {"GetNumberPlanes", PoincareAttributes_GetNumberPlanes, METH_VARARGS},
    {"SetSinglePlane", PoincareAttributes_SetSinglePlane, METH_VARARGS},
    {"GetSinglePlane", PoincareAttributes_GetSinglePlane, METH_VARARGS},
    {"SetMin", PoincareAttributes_SetMin, METH_VARARGS},
    {"GetMin", PoincareAttributes_GetMin, METH_VARARGS},
    {"SetMax", PoincareAttributes_SetMax, METH_VARARGS},
    {"GetMax", PoincareAttributes_GetMax, METH_VARARGS},
    {"SetMinFlag", PoincareAttributes_SetMinFlag, METH_VARARGS},
    {"GetMinFlag", PoincareAttributes_GetMinFlag, METH_VARARGS},
    {"SetMaxFlag", PoincareAttributes_SetMaxFlag, METH_VARARGS},
    {"GetMaxFlag", PoincareAttributes_GetMaxFlag, METH_VARARGS},
    {"SetColorType", PoincareAttributes_SetColorType, METH_VARARGS},
    {"GetColorType", PoincareAttributes_GetColorType, METH_VARARGS},
    {"SetSingleColor", PoincareAttributes_SetSingleColor, METH_VARARGS},
    {"GetSingleColor", PoincareAttributes_GetSingleColor, METH_VARARGS},
    {"SetColorTableName", PoincareAttributes_SetColorTableName, METH_VARARGS},
    {"GetColorTableName", PoincareAttributes_GetColorTableName, METH_VARARGS},
    {"SetDataValue", PoincareAttributes_SetDataValue, METH_VARARGS},
    {"GetDataValue", PoincareAttributes_GetDataValue, METH_VARARGS},
    {"SetShowRationalSurfaces", PoincareAttributes_SetShowRationalSurfaces, METH_VARARGS},
    {"GetShowRationalSurfaces", PoincareAttributes_GetShowRationalSurfaces, METH_VARARGS},
    {"SetRationalSurfaceMaxIterations", PoincareAttributes_SetRationalSurfaceMaxIterations, METH_VARARGS},
    {"GetRationalSurfaceMaxIterations", PoincareAttributes_GetRationalSurfaceMaxIterations, METH_VARARGS},
    {"SetShowOPoints", PoincareAttributes_SetShowOPoints, METH_VARARGS},
    {"GetShowOPoints", PoincareAttributes_GetShowOPoints, METH_VARARGS},
    {"SetOPointMaxIterations", PoincareAttributes_SetOPointMaxIterations, METH_VARARGS},
    {"GetOPointMaxIterations", PoincareAttributes_GetOPointMaxIterations, METH_VARARGS},
    {"SetShowXPoints", PoincareAttributes_SetShowXPoints, METH_VARARGS},
    {"GetShowXPoints", PoincareAttributes_GetShowXPoints, METH_VARARGS},
    {"SetXPointMaxIterations", PoincareAttributes_SetXPointMaxIterations, METH_VARARGS},
    {"GetXPointMaxIterations", PoincareAttributes_GetXPointMaxIterations, METH_VARARGS},
    {"SetPerformOLineAnalysis", PoincareAttributes_SetPerformOLineAnalysis, METH_VARARGS},
    {"GetPerformOLineAnalysis", PoincareAttributes_GetPerformOLineAnalysis, METH_VARARGS},
    {"SetOLineToroidalWinding", PoincareAttributes_SetOLineToroidalWinding, METH_VARARGS},
    {"GetOLineToroidalWinding", PoincareAttributes_GetOLineToroidalWinding, METH_VARARGS},
    {"SetOLineAxisFileName", PoincareAttributes_SetOLineAxisFileName, METH_VARARGS},
    {"GetOLineAxisFileName", PoincareAttributes_GetOLineAxisFileName, METH_VARARGS},
    {"SetShowChaotic", PoincareAttributes_SetShowChaotic, METH_VARARGS},
    {"GetShowChaotic", PoincareAttributes_GetShowChaotic, METH_VARARGS},
    {"SetShowIslands", PoincareAttributes_SetShowIslands, METH_VARARGS},
    {"GetShowIslands", PoincareAttributes_GetShowIslands, METH_VARARGS},
    {"SetSummaryFlag", PoincareAttributes_SetSummaryFlag, METH_VARARGS},
    {"GetSummaryFlag", PoincareAttributes_GetSummaryFlag, METH_VARARGS},
    {"SetVerboseFlag", PoincareAttributes_SetVerboseFlag, METH_VARARGS},
    {"GetVerboseFlag", PoincareAttributes_GetVerboseFlag, METH_VARARGS},
    {"SetShow1DPlots", PoincareAttributes_SetShow1DPlots, METH_VARARGS},
    {"GetShow1DPlots", PoincareAttributes_GetShow1DPlots, METH_VARARGS},
    {"SetShowLines", PoincareAttributes_SetShowLines, METH_VARARGS},
    {"GetShowLines", PoincareAttributes_GetShowLines, METH_VARARGS},
    {"SetShowPoints", PoincareAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", PoincareAttributes_GetShowPoints, METH_VARARGS},
    {"SetParallelizationAlgorithmType", PoincareAttributes_SetParallelizationAlgorithmType, METH_VARARGS},
    {"GetParallelizationAlgorithmType", PoincareAttributes_GetParallelizationAlgorithmType, METH_VARARGS},
    {"SetMaxProcessCount", PoincareAttributes_SetMaxProcessCount, METH_VARARGS},
    {"GetMaxProcessCount", PoincareAttributes_GetMaxProcessCount, METH_VARARGS},
    {"SetMaxDomainCacheSize", PoincareAttributes_SetMaxDomainCacheSize, METH_VARARGS},
    {"GetMaxDomainCacheSize", PoincareAttributes_GetMaxDomainCacheSize, METH_VARARGS},
    {"SetWorkGroupSize", PoincareAttributes_SetWorkGroupSize, METH_VARARGS},
    {"GetWorkGroupSize", PoincareAttributes_GetWorkGroupSize, METH_VARARGS},
    {"SetPathlines", PoincareAttributes_SetPathlines, METH_VARARGS},
    {"GetPathlines", PoincareAttributes_GetPathlines, METH_VARARGS},
    {"SetPathlinesOverrideStartingTimeFlag", PoincareAttributes_SetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"GetPathlinesOverrideStartingTimeFlag", PoincareAttributes_GetPathlinesOverrideStartingTimeFlag, METH_VARARGS},
    {"SetPathlinesOverrideStartingTime", PoincareAttributes_SetPathlinesOverrideStartingTime, METH_VARARGS},
    {"GetPathlinesOverrideStartingTime", PoincareAttributes_GetPathlinesOverrideStartingTime, METH_VARARGS},
    {"SetPathlinesPeriod", PoincareAttributes_SetPathlinesPeriod, METH_VARARGS},
    {"GetPathlinesPeriod", PoincareAttributes_GetPathlinesPeriod, METH_VARARGS},
    {"SetPathlinesCMFE", PoincareAttributes_SetPathlinesCMFE, METH_VARARGS},
    {"GetPathlinesCMFE", PoincareAttributes_GetPathlinesCMFE, METH_VARARGS},
    {"SetIssueTerminationWarnings", PoincareAttributes_SetIssueTerminationWarnings, METH_VARARGS},
    {"GetIssueTerminationWarnings", PoincareAttributes_GetIssueTerminationWarnings, METH_VARARGS},
    {"SetIssueStepsizeWarnings", PoincareAttributes_SetIssueStepsizeWarnings, METH_VARARGS},
    {"GetIssueStepsizeWarnings", PoincareAttributes_GetIssueStepsizeWarnings, METH_VARARGS},
    {"SetIssueStiffnessWarnings", PoincareAttributes_SetIssueStiffnessWarnings, METH_VARARGS},
    {"GetIssueStiffnessWarnings", PoincareAttributes_GetIssueStiffnessWarnings, METH_VARARGS},
    {"SetIssueCriticalPointsWarnings", PoincareAttributes_SetIssueCriticalPointsWarnings, METH_VARARGS},
    {"GetIssueCriticalPointsWarnings", PoincareAttributes_GetIssueCriticalPointsWarnings, METH_VARARGS},
    {"SetCriticalPointThreshold", PoincareAttributes_SetCriticalPointThreshold, METH_VARARGS},
    {"GetCriticalPointThreshold", PoincareAttributes_GetCriticalPointThreshold, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PoincareAttributes_dealloc(PyObject *v)
{
   PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PoincareAttributes_compare(PyObject *v, PyObject *w)
{
    PoincareAttributes *a = ((PoincareAttributesObject *)v)->data;
    PoincareAttributes *b = ((PoincareAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPoincareAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "opacityType") == 0)
        return PoincareAttributes_GetOpacityType(self, NULL);
    if(strcmp(name, "Explicit") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Explicit));
    if(strcmp(name, "ColorTable") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ColorTable));

    if(strcmp(name, "opacity") == 0)
        return PoincareAttributes_GetOpacity(self, NULL);
    if(strcmp(name, "minPunctures") == 0)
        return PoincareAttributes_GetMinPunctures(self, NULL);
    if(strcmp(name, "maxPunctures") == 0)
        return PoincareAttributes_GetMaxPunctures(self, NULL);
    if(strcmp(name, "puncturePlotType") == 0)
        return PoincareAttributes_GetPuncturePlotType(self, NULL);
    if(strcmp(name, "Single") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Single));
    if(strcmp(name, "Double") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Double));

    if(strcmp(name, "maxSteps") == 0)
        return PoincareAttributes_GetMaxSteps(self, NULL);
    if(strcmp(name, "terminateByTime") == 0)
        return PoincareAttributes_GetTerminateByTime(self, NULL);
    if(strcmp(name, "termTime") == 0)
        return PoincareAttributes_GetTermTime(self, NULL);
    if(strcmp(name, "puncturePeriodTolerance") == 0)
        return PoincareAttributes_GetPuncturePeriodTolerance(self, NULL);
    if(strcmp(name, "puncturePlane") == 0)
        return PoincareAttributes_GetPuncturePlane(self, NULL);
    if(strcmp(name, "Poloidal") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Poloidal));
    if(strcmp(name, "Toroidal") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Toroidal));
    if(strcmp(name, "Arbitrary") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Arbitrary));

    if(strcmp(name, "sourceType") == 0)
        return PoincareAttributes_GetSourceType(self, NULL);
    if(strcmp(name, "SpecifiedPoint") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SpecifiedPoint));
    if(strcmp(name, "PointList") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PointList));
    if(strcmp(name, "SpecifiedLine") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SpecifiedLine));

    if(strcmp(name, "pointSource") == 0)
        return PoincareAttributes_GetPointSource(self, NULL);
    if(strcmp(name, "pointList") == 0)
        return PoincareAttributes_GetPointList(self, NULL);
    if(strcmp(name, "lineStart") == 0)
        return PoincareAttributes_GetLineStart(self, NULL);
    if(strcmp(name, "lineEnd") == 0)
        return PoincareAttributes_GetLineEnd(self, NULL);
    if(strcmp(name, "pointDensity") == 0)
        return PoincareAttributes_GetPointDensity(self, NULL);
    if(strcmp(name, "fieldType") == 0)
        return PoincareAttributes_GetFieldType(self, NULL);
    if(strcmp(name, "Default") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Default));
    if(strcmp(name, "FlashField") == 0)
        return PyInt_FromLong(long(PoincareAttributes::FlashField));
    if(strcmp(name, "M3DC12DField") == 0)
        return PyInt_FromLong(long(PoincareAttributes::M3DC12DField));
    if(strcmp(name, "M3DC13DField") == 0)
        return PyInt_FromLong(long(PoincareAttributes::M3DC13DField));
    if(strcmp(name, "Nek5000Field") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Nek5000Field));
    if(strcmp(name, "NektarPPField") == 0)
        return PyInt_FromLong(long(PoincareAttributes::NektarPPField));
    if(strcmp(name, "NIMRODField") == 0)
        return PyInt_FromLong(long(PoincareAttributes::NIMRODField));

    if(strcmp(name, "forceNodeCenteredData") == 0)
        return PoincareAttributes_GetForceNodeCenteredData(self, NULL);
    if(strcmp(name, "fieldConstant") == 0)
        return PoincareAttributes_GetFieldConstant(self, NULL);
    if(strcmp(name, "velocitySource") == 0)
        return PoincareAttributes_GetVelocitySource(self, NULL);
    if(strcmp(name, "integrationType") == 0)
        return PoincareAttributes_GetIntegrationType(self, NULL);
    if(strcmp(name, "Euler") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Euler));
    if(strcmp(name, "Leapfrog") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Leapfrog));
    if(strcmp(name, "DormandPrince") == 0)
        return PyInt_FromLong(long(PoincareAttributes::DormandPrince));
    if(strcmp(name, "AdamsBashforth") == 0)
        return PyInt_FromLong(long(PoincareAttributes::AdamsBashforth));
    if(strcmp(name, "RK4") == 0)
        return PyInt_FromLong(long(PoincareAttributes::RK4));
    if(strcmp(name, "M3DC12DIntegrator") == 0)
        return PyInt_FromLong(long(PoincareAttributes::M3DC12DIntegrator));

    if(strcmp(name, "coordinateSystem") == 0)
        return PoincareAttributes_GetCoordinateSystem(self, NULL);
    if(strcmp(name, "Cartesian") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Cartesian));
    if(strcmp(name, "Cylindrical") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Cylindrical));

    if(strcmp(name, "maxStepLength") == 0)
        return PoincareAttributes_GetMaxStepLength(self, NULL);
    if(strcmp(name, "limitMaximumTimestep") == 0)
        return PoincareAttributes_GetLimitMaximumTimestep(self, NULL);
    if(strcmp(name, "maxTimeStep") == 0)
        return PoincareAttributes_GetMaxTimeStep(self, NULL);
    if(strcmp(name, "relTol") == 0)
        return PoincareAttributes_GetRelTol(self, NULL);
    if(strcmp(name, "absTolSizeType") == 0)
        return PoincareAttributes_GetAbsTolSizeType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Absolute));
    if(strcmp(name, "FractionOfBBox") == 0)
        return PyInt_FromLong(long(PoincareAttributes::FractionOfBBox));

    if(strcmp(name, "absTolAbsolute") == 0)
        return PoincareAttributes_GetAbsTolAbsolute(self, NULL);
    if(strcmp(name, "absTolBBox") == 0)
        return PoincareAttributes_GetAbsTolBBox(self, NULL);
    if(strcmp(name, "analysis") == 0)
        return PoincareAttributes_GetAnalysis(self, NULL);
    if(strcmp(name, "None") == 0)
        return PyInt_FromLong(long(PoincareAttributes::None));
    if(strcmp(name, "Normal") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Normal));

    if(strcmp(name, "maximumToroidalWinding") == 0)
        return PoincareAttributes_GetMaximumToroidalWinding(self, NULL);
    if(strcmp(name, "overrideToroidalWinding") == 0)
        return PoincareAttributes_GetOverrideToroidalWinding(self, NULL);
    if(strcmp(name, "overridePoloidalWinding") == 0)
        return PoincareAttributes_GetOverridePoloidalWinding(self, NULL);
    if(strcmp(name, "windingPairConfidence") == 0)
        return PoincareAttributes_GetWindingPairConfidence(self, NULL);
    if(strcmp(name, "rationalSurfaceFactor") == 0)
        return PoincareAttributes_GetRationalSurfaceFactor(self, NULL);
    if(strcmp(name, "overlaps") == 0)
        return PoincareAttributes_GetOverlaps(self, NULL);
    if(strcmp(name, "Raw") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Raw));
    if(strcmp(name, "Remove") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Remove));
    if(strcmp(name, "Merge") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Merge));
    if(strcmp(name, "Smooth") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Smooth));

    if(strcmp(name, "meshType") == 0)
        return PoincareAttributes_GetMeshType(self, NULL);
    if(strcmp(name, "Curves") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Curves));
    if(strcmp(name, "Surfaces") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Surfaces));

    if(strcmp(name, "numberPlanes") == 0)
        return PoincareAttributes_GetNumberPlanes(self, NULL);
    if(strcmp(name, "singlePlane") == 0)
        return PoincareAttributes_GetSinglePlane(self, NULL);
    if(strcmp(name, "min") == 0)
        return PoincareAttributes_GetMin(self, NULL);
    if(strcmp(name, "max") == 0)
        return PoincareAttributes_GetMax(self, NULL);
    if(strcmp(name, "minFlag") == 0)
        return PoincareAttributes_GetMinFlag(self, NULL);
    if(strcmp(name, "maxFlag") == 0)
        return PoincareAttributes_GetMaxFlag(self, NULL);
    if(strcmp(name, "colorType") == 0)
        return PoincareAttributes_GetColorType(self, NULL);
    if(strcmp(name, "ColorBySingleColor") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ColorBySingleColor));
    if(strcmp(name, "ColorByColorTable") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ColorByColorTable));

    if(strcmp(name, "singleColor") == 0)
        return PoincareAttributes_GetSingleColor(self, NULL);
    if(strcmp(name, "colorTableName") == 0)
        return PoincareAttributes_GetColorTableName(self, NULL);
    if(strcmp(name, "dataValue") == 0)
        return PoincareAttributes_GetDataValue(self, NULL);
    if(strcmp(name, "Solid") == 0)
        return PyInt_FromLong(long(PoincareAttributes::Solid));
    if(strcmp(name, "SafetyFactorQ") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SafetyFactorQ));
    if(strcmp(name, "SafetyFactorP") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SafetyFactorP));
    if(strcmp(name, "SafetyFactorQ_NotP") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SafetyFactorQ_NotP));
    if(strcmp(name, "SafetyFactorP_NotQ") == 0)
        return PyInt_FromLong(long(PoincareAttributes::SafetyFactorP_NotQ));
    if(strcmp(name, "ToroidalWindings") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ToroidalWindings));
    if(strcmp(name, "PoloidalWindingsQ") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PoloidalWindingsQ));
    if(strcmp(name, "PoloidalWindingsP") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PoloidalWindingsP));
    if(strcmp(name, "FieldlineOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::FieldlineOrder));
    if(strcmp(name, "PointOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PointOrder));
    if(strcmp(name, "PlaneOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::PlaneOrder));
    if(strcmp(name, "WindingGroupOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingGroupOrder));
    if(strcmp(name, "WindingPointOrder") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingPointOrder));
    if(strcmp(name, "WindingPointOrderModulo") == 0)
        return PyInt_FromLong(long(PoincareAttributes::WindingPointOrderModulo));

    if(strcmp(name, "showRationalSurfaces") == 0)
        return PoincareAttributes_GetShowRationalSurfaces(self, NULL);
    if(strcmp(name, "RationalSurfaceMaxIterations") == 0)
        return PoincareAttributes_GetRationalSurfaceMaxIterations(self, NULL);
    if(strcmp(name, "showOPoints") == 0)
        return PoincareAttributes_GetShowOPoints(self, NULL);
    if(strcmp(name, "OPointMaxIterations") == 0)
        return PoincareAttributes_GetOPointMaxIterations(self, NULL);
    if(strcmp(name, "showXPoints") == 0)
        return PoincareAttributes_GetShowXPoints(self, NULL);
    if(strcmp(name, "XPointMaxIterations") == 0)
        return PoincareAttributes_GetXPointMaxIterations(self, NULL);
    if(strcmp(name, "performOLineAnalysis") == 0)
        return PoincareAttributes_GetPerformOLineAnalysis(self, NULL);
    if(strcmp(name, "OLineToroidalWinding") == 0)
        return PoincareAttributes_GetOLineToroidalWinding(self, NULL);
    if(strcmp(name, "OLineAxisFileName") == 0)
        return PoincareAttributes_GetOLineAxisFileName(self, NULL);
    if(strcmp(name, "showChaotic") == 0)
        return PoincareAttributes_GetShowChaotic(self, NULL);
    if(strcmp(name, "showIslands") == 0)
        return PoincareAttributes_GetShowIslands(self, NULL);
    if(strcmp(name, "SummaryFlag") == 0)
        return PoincareAttributes_GetSummaryFlag(self, NULL);
    if(strcmp(name, "verboseFlag") == 0)
        return PoincareAttributes_GetVerboseFlag(self, NULL);
    if(strcmp(name, "show1DPlots") == 0)
        return PoincareAttributes_GetShow1DPlots(self, NULL);
    if(strcmp(name, "showLines") == 0)
        return PoincareAttributes_GetShowLines(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return PoincareAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "parallelizationAlgorithmType") == 0)
        return PoincareAttributes_GetParallelizationAlgorithmType(self, NULL);
    if(strcmp(name, "LoadOnDemand") == 0)
        return PyInt_FromLong(long(PoincareAttributes::LoadOnDemand));
    if(strcmp(name, "ParallelStaticDomains") == 0)
        return PyInt_FromLong(long(PoincareAttributes::ParallelStaticDomains));
    if(strcmp(name, "MasterSlave") == 0)
        return PyInt_FromLong(long(PoincareAttributes::MasterSlave));
    if(strcmp(name, "VisItSelects") == 0)
        return PyInt_FromLong(long(PoincareAttributes::VisItSelects));

    if(strcmp(name, "maxProcessCount") == 0)
        return PoincareAttributes_GetMaxProcessCount(self, NULL);
    if(strcmp(name, "maxDomainCacheSize") == 0)
        return PoincareAttributes_GetMaxDomainCacheSize(self, NULL);
    if(strcmp(name, "workGroupSize") == 0)
        return PoincareAttributes_GetWorkGroupSize(self, NULL);
    if(strcmp(name, "pathlines") == 0)
        return PoincareAttributes_GetPathlines(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        return PoincareAttributes_GetPathlinesOverrideStartingTimeFlag(self, NULL);
    if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        return PoincareAttributes_GetPathlinesOverrideStartingTime(self, NULL);
    if(strcmp(name, "pathlinesPeriod") == 0)
        return PoincareAttributes_GetPathlinesPeriod(self, NULL);
    if(strcmp(name, "pathlinesCMFE") == 0)
        return PoincareAttributes_GetPathlinesCMFE(self, NULL);
    if(strcmp(name, "CONN_CMFE") == 0)
        return PyInt_FromLong(long(PoincareAttributes::CONN_CMFE));
    if(strcmp(name, "POS_CMFE") == 0)
        return PyInt_FromLong(long(PoincareAttributes::POS_CMFE));

    if(strcmp(name, "issueTerminationWarnings") == 0)
        return PoincareAttributes_GetIssueTerminationWarnings(self, NULL);
    if(strcmp(name, "issueStepsizeWarnings") == 0)
        return PoincareAttributes_GetIssueStepsizeWarnings(self, NULL);
    if(strcmp(name, "issueStiffnessWarnings") == 0)
        return PoincareAttributes_GetIssueStiffnessWarnings(self, NULL);
    if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        return PoincareAttributes_GetIssueCriticalPointsWarnings(self, NULL);
    if(strcmp(name, "criticalPointThreshold") == 0)
        return PoincareAttributes_GetCriticalPointThreshold(self, NULL);

    return Py_FindMethod(PyPoincareAttributes_methods, self, name);
}

int
PyPoincareAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "opacityType") == 0)
        obj = PoincareAttributes_SetOpacityType(self, tuple);
    else if(strcmp(name, "opacity") == 0)
        obj = PoincareAttributes_SetOpacity(self, tuple);
    else if(strcmp(name, "minPunctures") == 0)
        obj = PoincareAttributes_SetMinPunctures(self, tuple);
    else if(strcmp(name, "maxPunctures") == 0)
        obj = PoincareAttributes_SetMaxPunctures(self, tuple);
    else if(strcmp(name, "puncturePlotType") == 0)
        obj = PoincareAttributes_SetPuncturePlotType(self, tuple);
    else if(strcmp(name, "maxSteps") == 0)
        obj = PoincareAttributes_SetMaxSteps(self, tuple);
    else if(strcmp(name, "terminateByTime") == 0)
        obj = PoincareAttributes_SetTerminateByTime(self, tuple);
    else if(strcmp(name, "termTime") == 0)
        obj = PoincareAttributes_SetTermTime(self, tuple);
    else if(strcmp(name, "puncturePeriodTolerance") == 0)
        obj = PoincareAttributes_SetPuncturePeriodTolerance(self, tuple);
    else if(strcmp(name, "puncturePlane") == 0)
        obj = PoincareAttributes_SetPuncturePlane(self, tuple);
    else if(strcmp(name, "sourceType") == 0)
        obj = PoincareAttributes_SetSourceType(self, tuple);
    else if(strcmp(name, "pointSource") == 0)
        obj = PoincareAttributes_SetPointSource(self, tuple);
    else if(strcmp(name, "pointList") == 0)
        obj = PoincareAttributes_SetPointList(self, tuple);
    else if(strcmp(name, "lineStart") == 0)
        obj = PoincareAttributes_SetLineStart(self, tuple);
    else if(strcmp(name, "lineEnd") == 0)
        obj = PoincareAttributes_SetLineEnd(self, tuple);
    else if(strcmp(name, "pointDensity") == 0)
        obj = PoincareAttributes_SetPointDensity(self, tuple);
    else if(strcmp(name, "fieldType") == 0)
        obj = PoincareAttributes_SetFieldType(self, tuple);
    else if(strcmp(name, "forceNodeCenteredData") == 0)
        obj = PoincareAttributes_SetForceNodeCenteredData(self, tuple);
    else if(strcmp(name, "fieldConstant") == 0)
        obj = PoincareAttributes_SetFieldConstant(self, tuple);
    else if(strcmp(name, "velocitySource") == 0)
        obj = PoincareAttributes_SetVelocitySource(self, tuple);
    else if(strcmp(name, "integrationType") == 0)
        obj = PoincareAttributes_SetIntegrationType(self, tuple);
    else if(strcmp(name, "coordinateSystem") == 0)
        obj = PoincareAttributes_SetCoordinateSystem(self, tuple);
    else if(strcmp(name, "maxStepLength") == 0)
        obj = PoincareAttributes_SetMaxStepLength(self, tuple);
    else if(strcmp(name, "limitMaximumTimestep") == 0)
        obj = PoincareAttributes_SetLimitMaximumTimestep(self, tuple);
    else if(strcmp(name, "maxTimeStep") == 0)
        obj = PoincareAttributes_SetMaxTimeStep(self, tuple);
    else if(strcmp(name, "relTol") == 0)
        obj = PoincareAttributes_SetRelTol(self, tuple);
    else if(strcmp(name, "absTolSizeType") == 0)
        obj = PoincareAttributes_SetAbsTolSizeType(self, tuple);
    else if(strcmp(name, "absTolAbsolute") == 0)
        obj = PoincareAttributes_SetAbsTolAbsolute(self, tuple);
    else if(strcmp(name, "absTolBBox") == 0)
        obj = PoincareAttributes_SetAbsTolBBox(self, tuple);
    else if(strcmp(name, "analysis") == 0)
        obj = PoincareAttributes_SetAnalysis(self, tuple);
    else if(strcmp(name, "maximumToroidalWinding") == 0)
        obj = PoincareAttributes_SetMaximumToroidalWinding(self, tuple);
    else if(strcmp(name, "overrideToroidalWinding") == 0)
        obj = PoincareAttributes_SetOverrideToroidalWinding(self, tuple);
    else if(strcmp(name, "overridePoloidalWinding") == 0)
        obj = PoincareAttributes_SetOverridePoloidalWinding(self, tuple);
    else if(strcmp(name, "windingPairConfidence") == 0)
        obj = PoincareAttributes_SetWindingPairConfidence(self, tuple);
    else if(strcmp(name, "rationalSurfaceFactor") == 0)
        obj = PoincareAttributes_SetRationalSurfaceFactor(self, tuple);
    else if(strcmp(name, "overlaps") == 0)
        obj = PoincareAttributes_SetOverlaps(self, tuple);
    else if(strcmp(name, "meshType") == 0)
        obj = PoincareAttributes_SetMeshType(self, tuple);
    else if(strcmp(name, "numberPlanes") == 0)
        obj = PoincareAttributes_SetNumberPlanes(self, tuple);
    else if(strcmp(name, "singlePlane") == 0)
        obj = PoincareAttributes_SetSinglePlane(self, tuple);
    else if(strcmp(name, "min") == 0)
        obj = PoincareAttributes_SetMin(self, tuple);
    else if(strcmp(name, "max") == 0)
        obj = PoincareAttributes_SetMax(self, tuple);
    else if(strcmp(name, "minFlag") == 0)
        obj = PoincareAttributes_SetMinFlag(self, tuple);
    else if(strcmp(name, "maxFlag") == 0)
        obj = PoincareAttributes_SetMaxFlag(self, tuple);
    else if(strcmp(name, "colorType") == 0)
        obj = PoincareAttributes_SetColorType(self, tuple);
    else if(strcmp(name, "singleColor") == 0)
        obj = PoincareAttributes_SetSingleColor(self, tuple);
    else if(strcmp(name, "colorTableName") == 0)
        obj = PoincareAttributes_SetColorTableName(self, tuple);
    else if(strcmp(name, "dataValue") == 0)
        obj = PoincareAttributes_SetDataValue(self, tuple);
    else if(strcmp(name, "showRationalSurfaces") == 0)
        obj = PoincareAttributes_SetShowRationalSurfaces(self, tuple);
    else if(strcmp(name, "RationalSurfaceMaxIterations") == 0)
        obj = PoincareAttributes_SetRationalSurfaceMaxIterations(self, tuple);
    else if(strcmp(name, "showOPoints") == 0)
        obj = PoincareAttributes_SetShowOPoints(self, tuple);
    else if(strcmp(name, "OPointMaxIterations") == 0)
        obj = PoincareAttributes_SetOPointMaxIterations(self, tuple);
    else if(strcmp(name, "showXPoints") == 0)
        obj = PoincareAttributes_SetShowXPoints(self, tuple);
    else if(strcmp(name, "XPointMaxIterations") == 0)
        obj = PoincareAttributes_SetXPointMaxIterations(self, tuple);
    else if(strcmp(name, "performOLineAnalysis") == 0)
        obj = PoincareAttributes_SetPerformOLineAnalysis(self, tuple);
    else if(strcmp(name, "OLineToroidalWinding") == 0)
        obj = PoincareAttributes_SetOLineToroidalWinding(self, tuple);
    else if(strcmp(name, "OLineAxisFileName") == 0)
        obj = PoincareAttributes_SetOLineAxisFileName(self, tuple);
    else if(strcmp(name, "showChaotic") == 0)
        obj = PoincareAttributes_SetShowChaotic(self, tuple);
    else if(strcmp(name, "showIslands") == 0)
        obj = PoincareAttributes_SetShowIslands(self, tuple);
    else if(strcmp(name, "SummaryFlag") == 0)
        obj = PoincareAttributes_SetSummaryFlag(self, tuple);
    else if(strcmp(name, "verboseFlag") == 0)
        obj = PoincareAttributes_SetVerboseFlag(self, tuple);
    else if(strcmp(name, "show1DPlots") == 0)
        obj = PoincareAttributes_SetShow1DPlots(self, tuple);
    else if(strcmp(name, "showLines") == 0)
        obj = PoincareAttributes_SetShowLines(self, tuple);
    else if(strcmp(name, "showPoints") == 0)
        obj = PoincareAttributes_SetShowPoints(self, tuple);
    else if(strcmp(name, "parallelizationAlgorithmType") == 0)
        obj = PoincareAttributes_SetParallelizationAlgorithmType(self, tuple);
    else if(strcmp(name, "maxProcessCount") == 0)
        obj = PoincareAttributes_SetMaxProcessCount(self, tuple);
    else if(strcmp(name, "maxDomainCacheSize") == 0)
        obj = PoincareAttributes_SetMaxDomainCacheSize(self, tuple);
    else if(strcmp(name, "workGroupSize") == 0)
        obj = PoincareAttributes_SetWorkGroupSize(self, tuple);
    else if(strcmp(name, "pathlines") == 0)
        obj = PoincareAttributes_SetPathlines(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTimeFlag") == 0)
        obj = PoincareAttributes_SetPathlinesOverrideStartingTimeFlag(self, tuple);
    else if(strcmp(name, "pathlinesOverrideStartingTime") == 0)
        obj = PoincareAttributes_SetPathlinesOverrideStartingTime(self, tuple);
    else if(strcmp(name, "pathlinesPeriod") == 0)
        obj = PoincareAttributes_SetPathlinesPeriod(self, tuple);
    else if(strcmp(name, "pathlinesCMFE") == 0)
        obj = PoincareAttributes_SetPathlinesCMFE(self, tuple);
    else if(strcmp(name, "issueTerminationWarnings") == 0)
        obj = PoincareAttributes_SetIssueTerminationWarnings(self, tuple);
    else if(strcmp(name, "issueStepsizeWarnings") == 0)
        obj = PoincareAttributes_SetIssueStepsizeWarnings(self, tuple);
    else if(strcmp(name, "issueStiffnessWarnings") == 0)
        obj = PoincareAttributes_SetIssueStiffnessWarnings(self, tuple);
    else if(strcmp(name, "issueCriticalPointsWarnings") == 0)
        obj = PoincareAttributes_SetIssueCriticalPointsWarnings(self, tuple);
    else if(strcmp(name, "criticalPointThreshold") == 0)
        obj = PoincareAttributes_SetCriticalPointThreshold(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PoincareAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
    fprintf(fp, "%s", PyPoincareAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PoincareAttributes_str(PyObject *v)
{
    PoincareAttributesObject *obj = (PoincareAttributesObject *)v;
    return PyString_FromString(PyPoincareAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PoincareAttributes_Purpose = "Attributes for the Poincare";
#else
static char *PoincareAttributes_Purpose = "Attributes for the Poincare";
#endif

//
// The type description structure
//
static PyTypeObject PoincareAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PoincareAttributes",                    // tp_name
    sizeof(PoincareAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PoincareAttributes_dealloc,  // tp_dealloc
    (printfunc)PoincareAttributes_print,     // tp_print
    (getattrfunc)PyPoincareAttributes_getattr, // tp_getattr
    (setattrfunc)PyPoincareAttributes_setattr, // tp_setattr
    (cmpfunc)PoincareAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PoincareAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PoincareAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PoincareAttributes *defaultAtts = 0;
static PoincareAttributes *currentAtts = 0;

static PyObject *
NewPoincareAttributes(int useCurrent)
{
    PoincareAttributesObject *newObject;
    newObject = PyObject_NEW(PoincareAttributesObject, &PoincareAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PoincareAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PoincareAttributes(*defaultAtts);
    else
        newObject->data = new PoincareAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPoincareAttributes(const PoincareAttributes *attr)
{
    PoincareAttributesObject *newObject;
    newObject = PyObject_NEW(PoincareAttributesObject, &PoincareAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PoincareAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PoincareAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPoincareAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PoincareAttributesMethods[] = {
    {"PoincareAttributes", PoincareAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PoincareAttributesObserver = 0;

std::string
PyPoincareAttributes_GetLogString()
{
    std::string s("PoincareAtts = PoincareAttributes()\n");
    if(currentAtts != 0)
        s += PyPoincareAttributes_ToString(currentAtts, "PoincareAtts.");
    return s;
}

static void
PyPoincareAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PoincareAtts = PoincareAttributes()\n");
        s += PyPoincareAttributes_ToString(currentAtts, "PoincareAtts.");
        cb(s);
    }
}

void
PyPoincareAttributes_StartUp(PoincareAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPoincareAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PoincareAttributesObserver == 0)
    {
        PoincareAttributesObserver = new ObserverToCallback(subj,
            PyPoincareAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPoincareAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PoincareAttributesObserver;
    PoincareAttributesObserver = 0;
}

PyMethodDef *
PyPoincareAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PoincareAttributesMethods;
}

bool
PyPoincareAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PoincareAttributesType);
}

PoincareAttributes *
PyPoincareAttributes_FromPyObject(PyObject *obj)
{
    PoincareAttributesObject *obj2 = (PoincareAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPoincareAttributes_New()
{
    return NewPoincareAttributes(0);
}

PyObject *
PyPoincareAttributes_Wrap(const PoincareAttributes *attr)
{
    return WrapPoincareAttributes(attr);
}

void
PyPoincareAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PoincareAttributesObject *obj2 = (PoincareAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPoincareAttributes_SetDefaults(const PoincareAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PoincareAttributes(*atts);
}

