// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PoincareCommonPluginInfo.C
// ****************************************************************************

#include <PoincarePluginInfo.h>
#include <PoincareAttributes.h>

#include <Expression.h>
#include <ExpressionList.h>
#include <avtDatabaseMetaData.h>
#include <avtVectorMetaData.h>

// ****************************************************************************
//  Method: PoincareCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PoincareCommonPluginInfo::AllocAttributes()
{
    return new PoincareAttributes;
}

// ****************************************************************************
//  Method: PoincareCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Poincare attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PoincareCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((PoincareAttributes *) to) = *((PoincareAttributes *) from);
}

// ****************************************************************************
//  Method: PoincareCommonPluginInfo::GetCreatedExpressions
//
//  Purpose:
//      Gets the expressions created by this operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

ExpressionList *
PoincareCommonPluginInfo::GetCreatedExpressions(const avtDatabaseMetaData *md) const
{
    char name[1024], defn[1024];
    ExpressionList *el = new ExpressionList;
    int numVectors = md->GetNumVectors();
    for (int i = 0; i < numVectors; i++)
    {
        const avtVectorMetaData *mmd = md->GetVector(i);
        if (mmd->hideFromGUI || !mmd->validVariable)
            continue;
        {
            Expression e2;
            sprintf(name, "operators/Poincare/%s", mmd->name.c_str());
            e2.SetName(name);
            e2.SetType(Expression::ScalarMeshVar);
            e2.SetFromOperator(true);
            e2.SetOperatorName("Poincare");
            sprintf(defn, "cell_constant(<%s>, 0.)", mmd->name.c_str());
            e2.SetDefinition(defn);
            el->AddExpressions(e2);
        }
    }
    const ExpressionList &oldEL = md->GetExprList();
    for (int i = 0; i < oldEL.GetNumExpressions(); i++)
    {
        const Expression &e = oldEL.GetExpressions(i);
        if (e.GetType() == Expression::VectorMeshVar)
        {
            {
                if (e.GetFromOperator() || e.GetAutoExpression())
                    continue; // weird ordering behavior otherwise
                Expression e2;
                sprintf(name, "operators/Poincare/%s", e.GetName().c_str());
                e2.SetName(name);
                e2.SetType(Expression::ScalarMeshVar);
                e2.SetFromOperator(true);
                e2.SetOperatorName("Poincare");
                sprintf(defn, "cell_constant(<%s>, 0.)", e.GetName().c_str());
                e2.SetDefinition(defn);
                el->AddExpressions(e2);
            }
        }
    }
    return el;
}

