// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyPersistentParticlesAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyPersistentParticlesAttributes
//
// Purpose:
//   This class contains attributes for the PersistentParticles operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a PersistentParticlesAttributes.
//
struct PersistentParticlesAttributesObject
{
    PyObject_HEAD
    PersistentParticlesAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewPersistentParticlesAttributes(int);

std::string
PyPersistentParticlesAttributes_ToString(const PersistentParticlesAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    snprintf(tmpStr, 1000, "%sstartIndex = %d\n", prefix, atts->GetStartIndex());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstopIndex = %d\n", prefix, atts->GetStopIndex());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sstride = %d\n", prefix, atts->GetStride());
    str += tmpStr;
    const char *startPathType_names = "Absolute, Relative";
    switch (atts->GetStartPathType())
    {
      case PersistentParticlesAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sstartPathType = %sAbsolute  # %s\n", prefix, prefix, startPathType_names);
          str += tmpStr;
          break;
      case PersistentParticlesAttributes::Relative:
          snprintf(tmpStr, 1000, "%sstartPathType = %sRelative  # %s\n", prefix, prefix, startPathType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    const char *stopPathType_names = "Absolute, Relative";
    switch (atts->GetStopPathType())
    {
      case PersistentParticlesAttributes::Absolute:
          snprintf(tmpStr, 1000, "%sstopPathType = %sAbsolute  # %s\n", prefix, prefix, stopPathType_names);
          str += tmpStr;
          break;
      case PersistentParticlesAttributes::Relative:
          snprintf(tmpStr, 1000, "%sstopPathType = %sRelative  # %s\n", prefix, prefix, stopPathType_names);
          str += tmpStr;
          break;
      default:
          break;
    }

    snprintf(tmpStr, 1000, "%straceVariableX = \"%s\"\n", prefix, atts->GetTraceVariableX().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%straceVariableY = \"%s\"\n", prefix, atts->GetTraceVariableY().c_str());
    str += tmpStr;
    snprintf(tmpStr, 1000, "%straceVariableZ = \"%s\"\n", prefix, atts->GetTraceVariableZ().c_str());
    str += tmpStr;
    if(atts->GetConnectParticles())
        snprintf(tmpStr, 1000, "%sconnectParticles = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sconnectParticles = 0\n", prefix);
    str += tmpStr;
    if(atts->GetShowPoints())
        snprintf(tmpStr, 1000, "%sshowPoints = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sshowPoints = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%sindexVariable = \"%s\"\n", prefix, atts->GetIndexVariable().c_str());
    str += tmpStr;
    return str;
}

static PyObject *
PersistentParticlesAttributes_Notify(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetStartIndex(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startIndex in the object.
    obj->data->SetStartIndex((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetStartIndex(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartIndex()));
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetStopIndex(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stopIndex in the object.
    obj->data->SetStopIndex((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetStopIndex(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStopIndex()));
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetStride(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stride in the object.
    obj->data->SetStride((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetStride(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStride()));
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetStartPathType(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the startPathType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetStartPathType(PersistentParticlesAttributes::PathTypeEnum(ival));
    else
    {
        fprintf(stderr, "An invalid startPathType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, Relative.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetStartPathType(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStartPathType()));
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetStopPathType(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the stopPathType in the object.
    if(ival >= 0 && ival < 2)
        obj->data->SetStopPathType(PersistentParticlesAttributes::PathTypeEnum(ival));
    else
    {
        fprintf(stderr, "An invalid stopPathType value was given. "
                        "Valid values are in the range of [0,1]. "
                        "You can also use the following names: "
                        "Absolute, Relative.");
        return NULL;
    }

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetStopPathType(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetStopPathType()));
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetTraceVariableX(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the traceVariableX in the object.
    obj->data->SetTraceVariableX(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetTraceVariableX(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTraceVariableX().c_str());
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetTraceVariableY(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the traceVariableY in the object.
    obj->data->SetTraceVariableY(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetTraceVariableY(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTraceVariableY().c_str());
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetTraceVariableZ(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the traceVariableZ in the object.
    obj->data->SetTraceVariableZ(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetTraceVariableZ(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetTraceVariableZ().c_str());
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetConnectParticles(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the connectParticles in the object.
    obj->data->SetConnectParticles(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetConnectParticles(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetConnectParticles()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetShowPoints(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the showPoints in the object.
    obj->data->SetShowPoints(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetShowPoints(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetShowPoints()?1L:0L);
    return retval;
}

/*static*/ PyObject *
PersistentParticlesAttributes_SetIndexVariable(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;

    char *str;
    if(!PyArg_ParseTuple(args, "s", &str))
        return NULL;

    // Set the indexVariable in the object.
    obj->data->SetIndexVariable(std::string(str));

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
PersistentParticlesAttributes_GetIndexVariable(PyObject *self, PyObject *args)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)self;
    PyObject *retval = PyString_FromString(obj->data->GetIndexVariable().c_str());
    return retval;
}



PyMethodDef PyPersistentParticlesAttributes_methods[PERSISTENTPARTICLESATTRIBUTES_NMETH] = {
    {"Notify", PersistentParticlesAttributes_Notify, METH_VARARGS},
    {"SetStartIndex", PersistentParticlesAttributes_SetStartIndex, METH_VARARGS},
    {"GetStartIndex", PersistentParticlesAttributes_GetStartIndex, METH_VARARGS},
    {"SetStopIndex", PersistentParticlesAttributes_SetStopIndex, METH_VARARGS},
    {"GetStopIndex", PersistentParticlesAttributes_GetStopIndex, METH_VARARGS},
    {"SetStride", PersistentParticlesAttributes_SetStride, METH_VARARGS},
    {"GetStride", PersistentParticlesAttributes_GetStride, METH_VARARGS},
    {"SetStartPathType", PersistentParticlesAttributes_SetStartPathType, METH_VARARGS},
    {"GetStartPathType", PersistentParticlesAttributes_GetStartPathType, METH_VARARGS},
    {"SetStopPathType", PersistentParticlesAttributes_SetStopPathType, METH_VARARGS},
    {"GetStopPathType", PersistentParticlesAttributes_GetStopPathType, METH_VARARGS},
    {"SetTraceVariableX", PersistentParticlesAttributes_SetTraceVariableX, METH_VARARGS},
    {"GetTraceVariableX", PersistentParticlesAttributes_GetTraceVariableX, METH_VARARGS},
    {"SetTraceVariableY", PersistentParticlesAttributes_SetTraceVariableY, METH_VARARGS},
    {"GetTraceVariableY", PersistentParticlesAttributes_GetTraceVariableY, METH_VARARGS},
    {"SetTraceVariableZ", PersistentParticlesAttributes_SetTraceVariableZ, METH_VARARGS},
    {"GetTraceVariableZ", PersistentParticlesAttributes_GetTraceVariableZ, METH_VARARGS},
    {"SetConnectParticles", PersistentParticlesAttributes_SetConnectParticles, METH_VARARGS},
    {"GetConnectParticles", PersistentParticlesAttributes_GetConnectParticles, METH_VARARGS},
    {"SetShowPoints", PersistentParticlesAttributes_SetShowPoints, METH_VARARGS},
    {"GetShowPoints", PersistentParticlesAttributes_GetShowPoints, METH_VARARGS},
    {"SetIndexVariable", PersistentParticlesAttributes_SetIndexVariable, METH_VARARGS},
    {"GetIndexVariable", PersistentParticlesAttributes_GetIndexVariable, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
PersistentParticlesAttributes_dealloc(PyObject *v)
{
   PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
PersistentParticlesAttributes_compare(PyObject *v, PyObject *w)
{
    PersistentParticlesAttributes *a = ((PersistentParticlesAttributesObject *)v)->data;
    PersistentParticlesAttributes *b = ((PersistentParticlesAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyPersistentParticlesAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "startIndex") == 0)
        return PersistentParticlesAttributes_GetStartIndex(self, NULL);
    if(strcmp(name, "stopIndex") == 0)
        return PersistentParticlesAttributes_GetStopIndex(self, NULL);
    if(strcmp(name, "stride") == 0)
        return PersistentParticlesAttributes_GetStride(self, NULL);
    if(strcmp(name, "startPathType") == 0)
        return PersistentParticlesAttributes_GetStartPathType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(PersistentParticlesAttributes::Absolute));
    if(strcmp(name, "Relative") == 0)
        return PyInt_FromLong(long(PersistentParticlesAttributes::Relative));

    if(strcmp(name, "stopPathType") == 0)
        return PersistentParticlesAttributes_GetStopPathType(self, NULL);
    if(strcmp(name, "Absolute") == 0)
        return PyInt_FromLong(long(PersistentParticlesAttributes::Absolute));
    if(strcmp(name, "Relative") == 0)
        return PyInt_FromLong(long(PersistentParticlesAttributes::Relative));

    if(strcmp(name, "traceVariableX") == 0)
        return PersistentParticlesAttributes_GetTraceVariableX(self, NULL);
    if(strcmp(name, "traceVariableY") == 0)
        return PersistentParticlesAttributes_GetTraceVariableY(self, NULL);
    if(strcmp(name, "traceVariableZ") == 0)
        return PersistentParticlesAttributes_GetTraceVariableZ(self, NULL);
    if(strcmp(name, "connectParticles") == 0)
        return PersistentParticlesAttributes_GetConnectParticles(self, NULL);
    if(strcmp(name, "showPoints") == 0)
        return PersistentParticlesAttributes_GetShowPoints(self, NULL);
    if(strcmp(name, "indexVariable") == 0)
        return PersistentParticlesAttributes_GetIndexVariable(self, NULL);

    return Py_FindMethod(PyPersistentParticlesAttributes_methods, self, name);
}

int
PyPersistentParticlesAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "startIndex") == 0)
        obj = PersistentParticlesAttributes_SetStartIndex(self, tuple);
    else if(strcmp(name, "stopIndex") == 0)
        obj = PersistentParticlesAttributes_SetStopIndex(self, tuple);
    else if(strcmp(name, "stride") == 0)
        obj = PersistentParticlesAttributes_SetStride(self, tuple);
    else if(strcmp(name, "startPathType") == 0)
        obj = PersistentParticlesAttributes_SetStartPathType(self, tuple);
    else if(strcmp(name, "stopPathType") == 0)
        obj = PersistentParticlesAttributes_SetStopPathType(self, tuple);
    else if(strcmp(name, "traceVariableX") == 0)
        obj = PersistentParticlesAttributes_SetTraceVariableX(self, tuple);
    else if(strcmp(name, "traceVariableY") == 0)
        obj = PersistentParticlesAttributes_SetTraceVariableY(self, tuple);
    else if(strcmp(name, "traceVariableZ") == 0)
        obj = PersistentParticlesAttributes_SetTraceVariableZ(self, tuple);
    else if(strcmp(name, "connectParticles") == 0)
        obj = PersistentParticlesAttributes_SetConnectParticles(self, tuple);
    else if(strcmp(name, "showPoints") == 0)
        obj = PersistentParticlesAttributes_SetShowPoints(self, tuple);
    else if(strcmp(name, "indexVariable") == 0)
        obj = PersistentParticlesAttributes_SetIndexVariable(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
PersistentParticlesAttributes_print(PyObject *v, FILE *fp, int flags)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)v;
    fprintf(fp, "%s", PyPersistentParticlesAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
PersistentParticlesAttributes_str(PyObject *v)
{
    PersistentParticlesAttributesObject *obj = (PersistentParticlesAttributesObject *)v;
    return PyString_FromString(PyPersistentParticlesAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *PersistentParticlesAttributes_Purpose = "This class contains attributes for the PersistentParticles operator.";
#else
static char *PersistentParticlesAttributes_Purpose = "This class contains attributes for the PersistentParticles operator.";
#endif

//
// The type description structure
//
static PyTypeObject PersistentParticlesAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "PersistentParticlesAttributes",                    // tp_name
    sizeof(PersistentParticlesAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)PersistentParticlesAttributes_dealloc,  // tp_dealloc
    (printfunc)PersistentParticlesAttributes_print,     // tp_print
    (getattrfunc)PyPersistentParticlesAttributes_getattr, // tp_getattr
    (setattrfunc)PyPersistentParticlesAttributes_setattr, // tp_setattr
    (cmpfunc)PersistentParticlesAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)PersistentParticlesAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    PersistentParticlesAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static PersistentParticlesAttributes *defaultAtts = 0;
static PersistentParticlesAttributes *currentAtts = 0;

static PyObject *
NewPersistentParticlesAttributes(int useCurrent)
{
    PersistentParticlesAttributesObject *newObject;
    newObject = PyObject_NEW(PersistentParticlesAttributesObject, &PersistentParticlesAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new PersistentParticlesAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new PersistentParticlesAttributes(*defaultAtts);
    else
        newObject->data = new PersistentParticlesAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapPersistentParticlesAttributes(const PersistentParticlesAttributes *attr)
{
    PersistentParticlesAttributesObject *newObject;
    newObject = PyObject_NEW(PersistentParticlesAttributesObject, &PersistentParticlesAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (PersistentParticlesAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
PersistentParticlesAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewPersistentParticlesAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef PersistentParticlesAttributesMethods[] = {
    {"PersistentParticlesAttributes", PersistentParticlesAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *PersistentParticlesAttributesObserver = 0;

std::string
PyPersistentParticlesAttributes_GetLogString()
{
    std::string s("PersistentParticlesAtts = PersistentParticlesAttributes()\n");
    if(currentAtts != 0)
        s += PyPersistentParticlesAttributes_ToString(currentAtts, "PersistentParticlesAtts.");
    return s;
}

static void
PyPersistentParticlesAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("PersistentParticlesAtts = PersistentParticlesAttributes()\n");
        s += PyPersistentParticlesAttributes_ToString(currentAtts, "PersistentParticlesAtts.");
        cb(s);
    }
}

void
PyPersistentParticlesAttributes_StartUp(PersistentParticlesAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyPersistentParticlesAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(PersistentParticlesAttributesObserver == 0)
    {
        PersistentParticlesAttributesObserver = new ObserverToCallback(subj,
            PyPersistentParticlesAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyPersistentParticlesAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete PersistentParticlesAttributesObserver;
    PersistentParticlesAttributesObserver = 0;
}

PyMethodDef *
PyPersistentParticlesAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return PersistentParticlesAttributesMethods;
}

bool
PyPersistentParticlesAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &PersistentParticlesAttributesType);
}

PersistentParticlesAttributes *
PyPersistentParticlesAttributes_FromPyObject(PyObject *obj)
{
    PersistentParticlesAttributesObject *obj2 = (PersistentParticlesAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyPersistentParticlesAttributes_New()
{
    return NewPersistentParticlesAttributes(0);
}

PyObject *
PyPersistentParticlesAttributes_Wrap(const PersistentParticlesAttributes *attr)
{
    return WrapPersistentParticlesAttributes(attr);
}

void
PyPersistentParticlesAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    PersistentParticlesAttributesObject *obj2 = (PersistentParticlesAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyPersistentParticlesAttributes_SetDefaults(const PersistentParticlesAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new PersistentParticlesAttributes(*atts);
}

