// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PersistentParticlesViewerEnginePluginInfo.C
// ****************************************************************************

#include <PersistentParticlesPluginInfo.h>
#include <PersistentParticlesAttributes.h>

//
// Storage for static data elements.
//
PersistentParticlesAttributes *PersistentParticlesViewerEnginePluginInfo::clientAtts = NULL;
PersistentParticlesAttributes *PersistentParticlesViewerEnginePluginInfo::defaultAtts = NULL;

// ****************************************************************************
//  Method:  PersistentParticlesViewerEnginePluginInfo::InitializeGlobalObjects
//
//  Purpose:
//    Initialize the operator atts.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************
void
PersistentParticlesViewerEnginePluginInfo::InitializeGlobalObjects()
{
    if (PersistentParticlesViewerEnginePluginInfo::clientAtts == NULL)
    {
        PersistentParticlesViewerEnginePluginInfo::clientAtts  = new PersistentParticlesAttributes;
        PersistentParticlesViewerEnginePluginInfo::defaultAtts = new PersistentParticlesAttributes;
    }
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Return a pointer to the viewer client attributes.
//
//  Returns:    A pointer to the viewer client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PersistentParticlesViewerEnginePluginInfo::GetClientAtts()
{
    return clientAtts;
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::GetDefaultAtts
//
//  Purpose:
//    Return a pointer to the viewer default attributes.
//
//  Returns:    A pointer to the viewer default attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PersistentParticlesViewerEnginePluginInfo::GetDefaultAtts()
{
    return defaultAtts;
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::SetClientAtts
//
//  Purpose:
//    Set the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to the new client attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PersistentParticlesViewerEnginePluginInfo::SetClientAtts(AttributeSubject *atts)
{
    *clientAtts = *(PersistentParticlesAttributes *)atts;
    clientAtts->Notify();
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::GetClientAtts
//
//  Purpose:
//    Get the viewer client attributes.
//
//  Arguments:
//    atts      A pointer to return the client default attributes in.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PersistentParticlesViewerEnginePluginInfo::GetClientAtts(AttributeSubject *atts)
{
    *(PersistentParticlesAttributes *)atts = *clientAtts;
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::InitializeOperatorAtts
//
//  Purpose:
//    Initialize the operator attributes to the default attributes.
//
//  Arguments:
//    atts        The attribute subject to initialize.
//    plot        The viewer plot that owns the operator.
//    fromDefault True to initialize the attributes from the defaults. False
//                to initialize from the current attributes.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PersistentParticlesViewerEnginePluginInfo::InitializeOperatorAtts(AttributeSubject *atts,
                                              const avtPlotMetaData &plot,
                                              const bool fromDefault)
{
    if (fromDefault)
        *(PersistentParticlesAttributes*)atts = *defaultAtts;
    else
        *(PersistentParticlesAttributes*)atts = *clientAtts;

    UpdateOperatorAtts(atts, plot);
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::UpdateOperatorAtts
//
//  Purpose:
//    Update the operator attributes when using operator expressions.
//
//  Arguments:
//    atts        The attribute subject to update.
//    plot        The viewer plot that owns the operator.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PersistentParticlesViewerEnginePluginInfo::UpdateOperatorAtts(AttributeSubject *atts, const avtPlotMetaData &plot)
{
}

// ****************************************************************************
//  Method: PersistentParticlesViewerEnginePluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the viewer menus.
//
//  Returns:    A pointer to the name to use in the viewer menus.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
PersistentParticlesViewerEnginePluginInfo::GetMenuName() const
{
    return "PersistentParticles";
}

