// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PersistentParticlesCommonPluginInfo.C
// ****************************************************************************

#include <PersistentParticlesPluginInfo.h>
#include <PersistentParticlesAttributes.h>

// ****************************************************************************
//  Method: PersistentParticlesCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PersistentParticlesCommonPluginInfo::AllocAttributes()
{
    return new PersistentParticlesAttributes;
}

// ****************************************************************************
//  Method: PersistentParticlesCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a PersistentParticles attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PersistentParticlesCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((PersistentParticlesAttributes *) to) = *((PersistentParticlesAttributes *) from);
}
