// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  PDFScriptingPluginInfo.C
// ************************************************************************* //
#include <PyPDFAttributes.h>
#include <PDFPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(PDF,Scripting)

// ****************************************************************************
// Method: PDFScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PDFScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyPDFAttributes_StartUp((PDFAttributes *)subj, data);
}

// ****************************************************************************
// Method: PDFScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
PDFScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyPDFAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: PDFScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is PDF plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
PDFScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyPDFAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: PDFScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
PDFScriptingPluginInfo::GetLogString()
{
    std::string s(PyPDFAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: PDFScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
PDFScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyPDFAttributes_SetDefaults((const PDFAttributes *)atts);
}
