// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PDFGUIPluginInfo.C
// ****************************************************************************

#include <PDFPluginInfo.h>
#include <PDFAttributes.h>
#include <QApplication>
#include <QvisPDFWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(PDF,GUI)

// ****************************************************************************
//  Method: PDFGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
PDFGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Probability Density Function"));
}


// ****************************************************************************
//  Method: PDFGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
PDFGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisPDFWindow(type, (PDFAttributes *)attr,
        caption, shortName, notepad);
}

