// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: PDFCommonPluginInfo.C
// ****************************************************************************

#include <PDFPluginInfo.h>
#include <PDFAttributes.h>

// ****************************************************************************
//  Method: PDFCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
PDFCommonPluginInfo::AllocAttributes()
{
    return new PDFAttributes;
}

// ****************************************************************************
//  Method: PDFCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a PDF attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
PDFCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((PDFAttributes *) to) = *((PDFAttributes *) from);
}
