// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  OnionPeelScriptingPluginInfo.C
// ************************************************************************* //
#include <PyOnionPeelAttributes.h>
#include <OnionPeelPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(OnionPeel,Scripting)

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
OnionPeelScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyOnionPeelAttributes_StartUp((OnionPeelAttributes *)subj, data);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
OnionPeelScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyOnionPeelAttributes_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is OnionPeel plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
OnionPeelScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyOnionPeelAttributes_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
OnionPeelScriptingPluginInfo::GetLogString()
{
    std::string s(PyOnionPeelAttributes_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: OnionPeelScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
OnionPeelScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyOnionPeelAttributes_SetDefaults((const OnionPeelAttributes *)atts);
}
