// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OnionPeelPluginInfo.h
// ****************************************************************************

#ifndef ONIONPEEL_PLUGIN_INFO_H
#define ONIONPEEL_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class OnionPeelAttributes;

// ****************************************************************************
//  Class: OnionPeelPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an OnionPeel operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class OnionPeelGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class OnionPeelCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual OnionPeelGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class OnionPeelGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual OnionPeelCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
    virtual const char **XPMIconData() const;
};

class OnionPeelViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual OnionPeelCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static OnionPeelAttributes *defaultAtts;
    static OnionPeelAttributes *clientAtts;
};

class OnionPeelViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual OnionPeelViewerEnginePluginInfo
{
  public:
    virtual const char **XPMIconData() const;
};

class OnionPeelEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual OnionPeelViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class OnionPeelScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual OnionPeelCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
