// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OnionPeelPluginInfo.C
// ****************************************************************************

#include <OnionPeelPluginInfo.h>
#include <OnionPeelAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(OnionPeel,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(OnionPeel,General)

// ****************************************************************************
//  Method: OnionPeelGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OnionPeelGeneralPluginInfo::GetName() const
{
    return "OnionPeel";
}

// ****************************************************************************
//  Method: OnionPeelGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OnionPeelGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: OnionPeelGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OnionPeelGeneralPluginInfo::GetID() const
{
    return "OnionPeel_1.0";
}
// ****************************************************************************
//  Method: OnionPeelGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
OnionPeelGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: OnionPeelGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
OnionPeelGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
