// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OnionPeelGUIPluginInfo.C
// ****************************************************************************

#include <OnionPeelPluginInfo.h>
#include <OnionPeelAttributes.h>
#include <QApplication>
#include <QvisOnionPeelWindow.h>

VISIT_OPERATOR_PLUGIN_ENTRY(OnionPeel,GUI)

// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::GetMenuName
//
//  Purpose:
//    Return a pointer to the name to use in the GUI menu.
//
//  Returns:    A pointer to the name to use in the GUI menu.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QString *
OnionPeelGUIPluginInfo::GetMenuName() const
{
    return new QString(qApp->translate("OperatorNames", "Onion Peel"));
}


// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::CreatePluginWindow
//
//  Purpose:
//    Return a pointer to an operator's attribute window.
//
//  Arguments:
//    type      The type of the operator.
//    attr      The attribute subject for the operator.
//    notepad   The notepad to use for posting the window.
//
//  Returns:    A pointer to the operator's attribute window.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

QvisPostableWindowObserver *
OnionPeelGUIPluginInfo::CreatePluginWindow(int type, AttributeSubject *attr,
    const QString &caption, const QString &shortName, QvisNotepadArea *notepad)
{
    return new QvisOnionPeelWindow(type, (OnionPeelAttributes *)attr,
        caption, shortName, notepad);
}

// ****************************************************************************
//  Method: OnionPeelGUIPluginInfo::XPMIconData
//
//  Purpose:
//    Return a pointer to the icon data.
//
//  Returns:    A pointer to the icon data.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

#include <OnionPeel.xpm>
const char **
OnionPeelGUIPluginInfo::XPMIconData() const
{
    return OnionPeel_xpm;
}

