// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: OnionPeelCommonPluginInfo.C
// ****************************************************************************

#include <OnionPeelPluginInfo.h>
#include <OnionPeelAttributes.h>

// ****************************************************************************
//  Method: OnionPeelCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
OnionPeelCommonPluginInfo::AllocAttributes()
{
    return new OnionPeelAttributes;
}

// ****************************************************************************
//  Method: OnionPeelCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a OnionPeel attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
OnionPeelCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((OnionPeelAttributes *) to) = *((OnionPeelAttributes *) from);
}
