// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MultiresControlPluginInfo.h
// ****************************************************************************

#ifndef MULTIRESCONTROL_PLUGIN_INFO_H
#define MULTIRESCONTROL_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class MultiresControlAttributes;

// ****************************************************************************
//  Class: MultiresControlPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an MultiresControl operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class MultiresControlGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class MultiresControlCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual MultiresControlGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class MultiresControlGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual MultiresControlCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class MultiresControlViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual MultiresControlCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static MultiresControlAttributes *defaultAtts;
    static MultiresControlAttributes *clientAtts;
};

class MultiresControlViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual MultiresControlViewerEnginePluginInfo
{
  public:
};

class MultiresControlEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual MultiresControlViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class MultiresControlScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual MultiresControlCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
