// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

package llnl.visit.operators;

import llnl.visit.AttributeSubject;
import llnl.visit.CommunicationBuffer;
import llnl.visit.Plugin;

// ****************************************************************************
// Class: MultiresControlAttributes
//
// Purpose:
//
// Notes:      Autogenerated by xml2java.
//
// Programmer: xml2java
// Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

public class MultiresControlAttributes extends AttributeSubject implements Plugin
{
    private static int MultiresControlAttributes_numAdditionalAtts = 3;

    public MultiresControlAttributes()
    {
        super(MultiresControlAttributes_numAdditionalAtts);

        resolution = 0;
        maxResolution = 1;
        info = new String("");
    }

    public MultiresControlAttributes(int nMoreFields)
    {
        super(MultiresControlAttributes_numAdditionalAtts + nMoreFields);

        resolution = 0;
        maxResolution = 1;
        info = new String("");
    }

    public MultiresControlAttributes(MultiresControlAttributes obj)
    {
        super(obj);

        resolution = obj.resolution;
        maxResolution = obj.maxResolution;
        info = new String(obj.info);

        SelectAll();
    }

    public int Offset()
    {
        return super.Offset() + super.GetNumAdditionalAttributes();
    }

    public int GetNumAdditionalAttributes()
    {
        return MultiresControlAttributes_numAdditionalAtts;
    }

    public boolean equals(MultiresControlAttributes obj)
    {
        // Create the return value
        return ((resolution == obj.resolution) &&
                (maxResolution == obj.maxResolution) &&
                (info.equals(obj.info)));
    }

    public String GetName() { return "MultiresControl"; }
    public String GetVersion() { return "1.0"; }

    // Property setting methods
    public void SetResolution(int resolution_)
    {
        resolution = resolution_;
        Select(0);
    }

    public void SetMaxResolution(int maxResolution_)
    {
        maxResolution = maxResolution_;
        Select(1);
    }

    public void SetInfo(String info_)
    {
        info = info_;
        Select(2);
    }

    // Property getting methods
    public int    GetResolution() { return resolution; }
    public int    GetMaxResolution() { return maxResolution; }
    public String GetInfo() { return info; }

    // Write and read methods.
    public void WriteAtts(CommunicationBuffer buf)
    {
        if(WriteSelect(0, buf))
            buf.WriteInt(resolution);
        if(WriteSelect(1, buf))
            buf.WriteInt(maxResolution);
        if(WriteSelect(2, buf))
            buf.WriteString(info);
    }

    public void ReadAtts(int index, CommunicationBuffer buf)
    {
        switch(index)
        {
        case 0:
            SetResolution(buf.ReadInt());
            break;
        case 1:
            SetMaxResolution(buf.ReadInt());
            break;
        case 2:
            SetInfo(buf.ReadString());
            break;
        }
    }

    public String toString(String indent)
    {
        String str = new String();
        str = str + intToString("resolution", resolution, indent) + "\n";
        str = str + intToString("maxResolution", maxResolution, indent) + "\n";
        str = str + stringToString("info", info, indent) + "\n";
        return str;
    }


    // Attributes
    private int    resolution;
    private int    maxResolution;
    private String info;
}

