// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  ModelFitScriptingPluginInfo.C
// ************************************************************************* //
#include <PyModelFitAtts.h>
#include <ModelFitPluginInfo.h>

VISIT_OPERATOR_PLUGIN_ENTRY(ModelFit,Scripting)

// ****************************************************************************
// Method: ModelFitScriptingPluginInfo::InitializePlugin
//
// Purpose:
//   Calls the initialization function for the plugin.
//
// Arguments:
//   subj    : A pointer to the plugin's state object.
//   data    : A pointer to data to be used by the observer function.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ModelFitScriptingPluginInfo::InitializePlugin(AttributeSubject *subj,
    void *data)
{
    PyModelFitAtts_StartUp((ModelFitAtts *)subj, data);
}

// ****************************************************************************
// Method: ModelFitScriptingPluginInfo::GetMethodTable
//
// Purpose:
//   Returns a pointer to the plugin's Python method table. These methods are
//   added to the top-level visit module's methods.
//
// Arguments:
//   nMethods : Returns the number of methods in the method table.
//
// Returns:    A pointer to the method table.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void *
ModelFitScriptingPluginInfo::GetMethodTable(int *nMethods)
{
    return PyModelFitAtts_GetMethodTable(nMethods);
}

// ****************************************************************************
// Method: ModelFitScriptingPluginInfo::TypesMatch
//
// Purpose:
//   Returns whether or not the input PyObject is ModelFit plot attributes.
//
// Arguments:
//   pyobject : A PyObject cast to void*.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

bool
ModelFitScriptingPluginInfo::TypesMatch(void *pyobject)
{
    return PyModelFitAtts_Check((PyObject *)pyobject);
}

// ****************************************************************************
// Method: ModelFitScriptingPluginInfo::GetLogString
//
// Purpose:
//   Gets a string representation of the current attributes.
//
// Arguments:
//   val : Whether or not to log state information.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

char *
ModelFitScriptingPluginInfo::GetLogString()
{
    std::string s(PyModelFitAtts_GetLogString());
    char *v = new char[s.size() + 1];
    strcpy(v, s.c_str());
    return v;
}

// ****************************************************************************
// Method: ModelFitScriptingPluginInfo::SetDefaults
//
// Purpose:
//   Used to set the default values for a plugin's state object.
//
// Arguments:
//   atts : The new state.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// Modifications:
//
// ****************************************************************************

void
ModelFitScriptingPluginInfo::SetDefaults(const AttributeSubject *atts)
{
    PyModelFitAtts_SetDefaults((const ModelFitAtts *)atts);
}
