// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtMetricThresholdFilter.h
// ************************************************************************* //

#ifndef AVT_MetricThreshold_FILTER_H
#define AVT_MetricThreshold_FILTER_H

#include <avtPluginDataTreeIterator.h>

#include <MetricThresholdAttributes.h>

class vtkDataSet;
class vtkDataArray;
class vtkPoints;
class vtkRectilinearGrid;


// ****************************************************************************
//  Class: avtMetricThresholdFilter
//
//  Purpose:
//      A plugin operator for MetricThreshold.
//
//  Programmer: haddox1 -- generated by xml2info
//  Creation:   Fri Jun 14 15:42:05 PST 2002
//
//  Modifications:
//    Eric Brugger, Wed Jul 30 19:15:25 PDT 2014
//    Modified the class to work with avtDataRepresentation.
//
// ****************************************************************************

class avtMetricThresholdFilter : public avtPluginDataTreeIterator
{
  public:
                         avtMetricThresholdFilter();
    virtual             ~avtMetricThresholdFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtMetricThresholdFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Metric Threshold"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    MetricThresholdAttributes   atts;

    virtual avtDataRepresentation *ExecuteData(avtDataRepresentation *);
    virtual void         UpdateDataObjectInfo();

    vtkDataSet          *ExecuteOnScalarData(vtkDataSet *, vtkDataArray *);
    vtkPoints           *CreateRectilinearPoints(vtkRectilinearGrid *);
    inline bool          PassesTest(int type, double value);
};


#endif
