// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisMetricThresholdWindow.h"

#include <MetricThresholdAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>
#include <QComboBox>


// ****************************************************************************
// Method: QvisMetricThresholdWindow::QvisMetricThresholdWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMetricThresholdWindow::QvisMetricThresholdWindow(const int type,
                         MetricThresholdAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisMetricThresholdWindow::~QvisMetricThresholdWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMetricThresholdWindow::~QvisMetricThresholdWindow()
{
}


// ****************************************************************************
// Method: QvisMetricThresholdWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 11:30:19 PDT 2008
//   Qt4 Port - Autogen and moved preset options into a ComboBox instead of 
//   a set radio of buttons.
//
// ****************************************************************************

void
QvisMetricThresholdWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    QWidget *presetLabel = new QLabel(tr("preset"), central);
    mainLayout->addWidget(presetLabel,0,0);
    
    preset = new QComboBox(central);
    preset->addItem(tr("None"));
    preset->addItem(tr("Aspect Ratio"));
    preset->addItem(tr("Aspect Gamma"));
    preset->addItem(tr("Skew"));
    preset->addItem(tr("Taper"));
    preset->addItem(tr("Volume"));
    preset->addItem(tr("Stretch"));
    preset->addItem(tr("Diagonal"));
    preset->addItem(tr("Dimension"));
    preset->addItem(tr("Oddy"));
    preset->addItem(tr("Condition"));
    preset->addItem(tr("Jacobian"));
    preset->addItem(tr("Scaled Jacobian"));
    preset->addItem(tr("Shear"));
    preset->addItem(tr("Shape"));
    preset->addItem(tr("Relative Size"));
    preset->addItem(tr("Shape and Size"));
    preset->addItem(tr("Area"));
    preset->addItem(tr("Warpage"));
    preset->addItem(tr("Smallest Angle"));
    preset->addItem(tr("Largest Angle"));

    connect(preset, SIGNAL(currentIndexChanged(int)),
            this, SLOT(presetChanged(int)));
    mainLayout->addWidget(preset, 0,1);

    Hexahedron = new QCheckBox(tr("Hexahedron"), central);
    connect(Hexahedron, SIGNAL(toggled(bool)),
            this, SLOT(HexahedronChanged(bool)));
    mainLayout->addWidget(Hexahedron, 1,0);

    QWidget *hex_lowerLabel = new QLabel(tr("hex_lower"), central);
    mainLayout->addWidget(hex_lowerLabel,2,0);
    hex_lower = new QLineEdit(central);
    connect(hex_lower, SIGNAL(returnPressed()),
            this, SLOT(hex_lowerProcessText()));
    mainLayout->addWidget(hex_lower, 2,1);

    QWidget *hex_upperLabel = new QLabel(tr("hex_upper"), central);
    mainLayout->addWidget(hex_upperLabel,3,0);
    hex_upper = new QLineEdit(central);
    connect(hex_upper, SIGNAL(returnPressed()),
            this, SLOT(hex_upperProcessText()));
    mainLayout->addWidget(hex_upper, 3,1);

    Tetrahedron = new QCheckBox(tr("Tetrahedron"), central);
    connect(Tetrahedron, SIGNAL(toggled(bool)),
            this, SLOT(TetrahedronChanged(bool)));
    mainLayout->addWidget(Tetrahedron, 4,0);

    QWidget *tet_lowerLabel = new QLabel(tr("tet_lower"), central);
    mainLayout->addWidget(tet_lowerLabel,5,0);
    tet_lower = new QLineEdit(central);
    connect(tet_lower, SIGNAL(returnPressed()),
            this, SLOT(tet_lowerProcessText()));
    mainLayout->addWidget(tet_lower, 5,1);

    QWidget *tet_upperLabel = new QLabel(tr("tet_upper"), central);
    mainLayout->addWidget(tet_upperLabel,6,0);
    tet_upper = new QLineEdit(central);
    connect(tet_upper, SIGNAL(returnPressed()),
            this, SLOT(tet_upperProcessText()));
    mainLayout->addWidget(tet_upper, 6,1);

    Wedge = new QCheckBox(tr("Wedge"), central);
    connect(Wedge, SIGNAL(toggled(bool)),
            this, SLOT(WedgeChanged(bool)));
    mainLayout->addWidget(Wedge, 7,0);

    QWidget *wed_lowerLabel = new QLabel(tr("wed_lower"), central);
    mainLayout->addWidget(wed_lowerLabel,8,0);
    wed_lower = new QLineEdit(central);
    connect(wed_lower, SIGNAL(returnPressed()),
            this, SLOT(wed_lowerProcessText()));
    mainLayout->addWidget(wed_lower, 8,1);

    QWidget *wed_upperLabel = new QLabel(tr("wed_upper"), central);
    mainLayout->addWidget(wed_upperLabel,9,0);
    wed_upper = new QLineEdit(central);
    connect(wed_upper, SIGNAL(returnPressed()),
            this, SLOT(wed_upperProcessText()));
    mainLayout->addWidget(wed_upper, 9,1);

    Pyramid = new QCheckBox(tr("Pyramid"), central);
    connect(Pyramid, SIGNAL(toggled(bool)),
            this, SLOT(PyramidChanged(bool)));
    mainLayout->addWidget(Pyramid, 10,0);

    QWidget *pyr_lowerLabel = new QLabel(tr("pyr_lower"), central);
    mainLayout->addWidget(pyr_lowerLabel,11,0);
    pyr_lower = new QLineEdit(central);
    connect(pyr_lower, SIGNAL(returnPressed()),
            this, SLOT(pyr_lowerProcessText()));
    mainLayout->addWidget(pyr_lower, 11,1);

    QWidget *pyr_upperLabel = new QLabel(tr("pyr_upper"), central);
    mainLayout->addWidget(pyr_upperLabel,12,0);
    pyr_upper = new QLineEdit(central);
    connect(pyr_upper, SIGNAL(returnPressed()),
            this, SLOT(pyr_upperProcessText()));
    mainLayout->addWidget(pyr_upper, 12,1);

    Triangle = new QCheckBox(tr("Triangle"), central);
    connect(Triangle, SIGNAL(toggled(bool)),
            this, SLOT(TriangleChanged(bool)));
    mainLayout->addWidget(Triangle, 13,0);

    QWidget *tri_lowerLabel = new QLabel(tr("tri_lower"), central);
    mainLayout->addWidget(tri_lowerLabel,14,0);
    tri_lower = new QLineEdit(central);
    connect(tri_lower, SIGNAL(returnPressed()),
            this, SLOT(tri_lowerProcessText()));
    mainLayout->addWidget(tri_lower, 14,1);

    QWidget *tri_upperLabel = new QLabel(tr("tri_upper"), central);
    mainLayout->addWidget(tri_upperLabel,15,0);
    tri_upper = new QLineEdit(central);
    connect(tri_upper, SIGNAL(returnPressed()),
            this, SLOT(tri_upperProcessText()));
    mainLayout->addWidget(tri_upper, 15,1);

    Quad = new QCheckBox(tr("Quad"), central);
    connect(Quad, SIGNAL(toggled(bool)),
            this, SLOT(QuadChanged(bool)));
    mainLayout->addWidget(Quad, 16,0);

    QWidget *quad_lowerLabel = new QLabel(tr("quad_lower"), central);
    mainLayout->addWidget(quad_lowerLabel,17,0);
    quad_lower = new QLineEdit(central);
    connect(quad_lower, SIGNAL(returnPressed()),
            this, SLOT(quad_lowerProcessText()));
    mainLayout->addWidget(quad_lower, 17,1);

    QWidget *quad_upperLabel = new QLabel(tr("quad_upper"), central);
    mainLayout->addWidget(quad_upperLabel,18,0);
    quad_upper = new QLineEdit(central);
    connect(quad_upper, SIGNAL(returnPressed()),
            this, SLOT(quad_upperProcessText()));
    mainLayout->addWidget(quad_upper, 18,1);

}


// ****************************************************************************
// Method: QvisMetricThresholdWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   Cyrus Harrison, Tue Aug 19 11:30:19 PDT 2008
//   Qt4 Port. 
//
// ****************************************************************************

void
QvisMetricThresholdWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case MetricThresholdAttributes::ID_preset:
            preset->blockSignals(true);
            preset->setCurrentIndex((int)atts->GetPreset());
            preset->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_Hexahedron:
            Hexahedron->blockSignals(true);
            Hexahedron->setChecked(atts->GetHexahedron());
            Hexahedron->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_hex_lower:
            hex_lower->setText(DoubleToQString(atts->GetHex_lower()));
            break;
          case MetricThresholdAttributes::ID_hex_upper:
            hex_upper->setText(DoubleToQString(atts->GetHex_upper()));
            break;
          case MetricThresholdAttributes::ID_Tetrahedron:
            Tetrahedron->blockSignals(true);
            Tetrahedron->setChecked(atts->GetTetrahedron());
            Tetrahedron->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_tet_lower:
            tet_lower->setText(DoubleToQString(atts->GetTet_lower()));
            break;
          case MetricThresholdAttributes::ID_tet_upper:
            tet_upper->setText(DoubleToQString(atts->GetTet_upper()));
            break;
          case MetricThresholdAttributes::ID_Wedge:
            Wedge->blockSignals(true);
            Wedge->setChecked(atts->GetWedge());
            Wedge->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_wed_lower:
            wed_lower->setText(DoubleToQString(atts->GetWed_lower()));
            break;
          case MetricThresholdAttributes::ID_wed_upper:
            wed_upper->setText(DoubleToQString(atts->GetWed_upper()));
            break;
          case MetricThresholdAttributes::ID_Pyramid:
            Pyramid->blockSignals(true);
            Pyramid->setChecked(atts->GetPyramid());
            Pyramid->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_pyr_lower:
            pyr_lower->setText(DoubleToQString(atts->GetPyr_lower()));
            break;
          case MetricThresholdAttributes::ID_pyr_upper:
            pyr_upper->setText(DoubleToQString(atts->GetPyr_upper()));
            break;
          case MetricThresholdAttributes::ID_Triangle:
            Triangle->blockSignals(true);
            Triangle->setChecked(atts->GetTriangle());
            Triangle->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_tri_lower:
            tri_lower->setText(DoubleToQString(atts->GetTri_lower()));
            break;
          case MetricThresholdAttributes::ID_tri_upper:
            tri_upper->setText(DoubleToQString(atts->GetTri_upper()));
            break;
          case MetricThresholdAttributes::ID_Quad:
            Quad->blockSignals(true);
            Quad->setChecked(atts->GetQuad());
            Quad->blockSignals(false);
            break;
          case MetricThresholdAttributes::ID_quad_lower:
            quad_lower->setText(DoubleToQString(atts->GetQuad_lower()));
            break;
          case MetricThresholdAttributes::ID_quad_upper:
            quad_upper->setText(DoubleToQString(atts->GetQuad_upper()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisMetricThresholdWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMetricThresholdWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do hex_lower
    if(which_widget == MetricThresholdAttributes::ID_hex_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(hex_lower, val))
            atts->SetHex_lower(val);
        else
        {
            ResettingError(tr("hex_lower"),
                DoubleToQString(atts->GetHex_lower()));
            atts->SetHex_lower(atts->GetHex_lower());
        }
    }

    // Do hex_upper
    if(which_widget == MetricThresholdAttributes::ID_hex_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(hex_upper, val))
            atts->SetHex_upper(val);
        else
        {
            ResettingError(tr("hex_upper"),
                DoubleToQString(atts->GetHex_upper()));
            atts->SetHex_upper(atts->GetHex_upper());
        }
    }

    // Do tet_lower
    if(which_widget == MetricThresholdAttributes::ID_tet_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(tet_lower, val))
            atts->SetTet_lower(val);
        else
        {
            ResettingError(tr("tet_lower"),
                DoubleToQString(atts->GetTet_lower()));
            atts->SetTet_lower(atts->GetTet_lower());
        }
    }

    // Do tet_upper
    if(which_widget == MetricThresholdAttributes::ID_tet_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(tet_upper, val))
            atts->SetTet_upper(val);
        else
        {
            ResettingError(tr("tet_upper"),
                DoubleToQString(atts->GetTet_upper()));
            atts->SetTet_upper(atts->GetTet_upper());
        }
    }

    // Do wed_lower
    if(which_widget == MetricThresholdAttributes::ID_wed_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(wed_lower, val))
            atts->SetWed_lower(val);
        else
        {
            ResettingError(tr("wed_lower"),
                DoubleToQString(atts->GetWed_lower()));
            atts->SetWed_lower(atts->GetWed_lower());
        }
    }

    // Do wed_upper
    if(which_widget == MetricThresholdAttributes::ID_wed_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(wed_upper, val))
            atts->SetWed_upper(val);
        else
        {
            ResettingError(tr("wed_upper"),
                DoubleToQString(atts->GetWed_upper()));
            atts->SetWed_upper(atts->GetWed_upper());
        }
    }

    // Do pyr_lower
    if(which_widget == MetricThresholdAttributes::ID_pyr_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(pyr_lower, val))
            atts->SetPyr_lower(val);
        else
        {
            ResettingError(tr("pyr_lower"),
                DoubleToQString(atts->GetPyr_lower()));
            atts->SetPyr_lower(atts->GetPyr_lower());
        }
    }

    // Do pyr_upper
    if(which_widget == MetricThresholdAttributes::ID_pyr_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(pyr_upper, val))
            atts->SetPyr_upper(val);
        else
        {
            ResettingError(tr("pyr_upper"),
                DoubleToQString(atts->GetPyr_upper()));
            atts->SetPyr_upper(atts->GetPyr_upper());
        }
    }

    // Do tri_lower
    if(which_widget == MetricThresholdAttributes::ID_tri_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(tri_lower, val))
            atts->SetTri_lower(val);
        else
        {
            ResettingError(tr("tri_lower"),
                DoubleToQString(atts->GetTri_lower()));
            atts->SetTri_lower(atts->GetTri_lower());
        }
    }

    // Do tri_upper
    if(which_widget == MetricThresholdAttributes::ID_tri_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(tri_upper, val))
            atts->SetTri_upper(val);
        else
        {
            ResettingError(tr("tri_upper"),
                DoubleToQString(atts->GetTri_upper()));
            atts->SetTri_upper(atts->GetTri_upper());
        }
    }

    // Do quad_lower
    if(which_widget == MetricThresholdAttributes::ID_quad_lower || doAll)
    {
        double val;
        if(LineEditGetDouble(quad_lower, val))
            atts->SetQuad_lower(val);
        else
        {
            ResettingError(tr("quad_lower"),
                DoubleToQString(atts->GetQuad_lower()));
            atts->SetQuad_lower(atts->GetQuad_lower());
        }
    }

    // Do quad_upper
    if(which_widget == MetricThresholdAttributes::ID_quad_upper || doAll)
    {
        double val;
        if(LineEditGetDouble(quad_upper, val))
            atts->SetQuad_upper(val);
        else
        {
            ResettingError(tr("quad_upper"),
                DoubleToQString(atts->GetQuad_upper()));
            atts->SetQuad_upper(atts->GetQuad_upper());
        }
    }

}


//
// Qt Slot functions
//


void
QvisMetricThresholdWindow::presetChanged(int val)
{
    if(val != atts->GetPreset())
    {
        atts->SetPreset(MetricThresholdAttributes::Preset(val));
        SetUpdate(false);
        Apply();
    }
}


void
QvisMetricThresholdWindow::HexahedronChanged(bool val)
{
    atts->SetHexahedron(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::hex_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_hex_lower);
    Apply();
}


void
QvisMetricThresholdWindow::hex_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_hex_upper);
    Apply();
}


void
QvisMetricThresholdWindow::TetrahedronChanged(bool val)
{
    atts->SetTetrahedron(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::tet_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_tet_lower);
    Apply();
}


void
QvisMetricThresholdWindow::tet_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_tet_upper);
    Apply();
}


void
QvisMetricThresholdWindow::WedgeChanged(bool val)
{
    atts->SetWedge(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::wed_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_wed_lower);
    Apply();
}


void
QvisMetricThresholdWindow::wed_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_wed_upper);
    Apply();
}


void
QvisMetricThresholdWindow::PyramidChanged(bool val)
{
    atts->SetPyramid(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::pyr_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_pyr_lower);
    Apply();
}


void
QvisMetricThresholdWindow::pyr_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_pyr_upper);
    Apply();
}


void
QvisMetricThresholdWindow::TriangleChanged(bool val)
{
    atts->SetTriangle(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::tri_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_tri_lower);
    Apply();
}


void
QvisMetricThresholdWindow::tri_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_tri_upper);
    Apply();
}


void
QvisMetricThresholdWindow::QuadChanged(bool val)
{
    atts->SetQuad(val);
    SetUpdate(false);
    Apply();
}


void
QvisMetricThresholdWindow::quad_lowerProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_quad_lower);
    Apply();
}


void
QvisMetricThresholdWindow::quad_upperProcessText()
{
    GetCurrentValues(MetricThresholdAttributes::ID_quad_upper);
    Apply();
}


