// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MetricThresholdPluginInfo.h
// ****************************************************************************

#ifndef METRICTHRESHOLD_PLUGIN_INFO_H
#define METRICTHRESHOLD_PLUGIN_INFO_H
#include <OperatorPluginInfo.h>
#include <operator_plugin_exports.h>

class MetricThresholdAttributes;

// ****************************************************************************
//  Class: MetricThresholdPluginInfo
//
//  Purpose:
//    Five classes that provide all the information about an MetricThreshold operator
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
//  Modifications:
//
// ****************************************************************************

class MetricThresholdGeneralPluginInfo : public virtual GeneralOperatorPluginInfo
{
  public:
    virtual const char *GetName() const;
    virtual const char *GetVersion() const;
    virtual const char *GetID() const;
    virtual bool  EnabledByDefault() const;
    virtual const char *GetCategoryName() const;
};

class MetricThresholdCommonPluginInfo : public virtual CommonOperatorPluginInfo, public virtual MetricThresholdGeneralPluginInfo
{
  public:
    virtual AttributeSubject *AllocAttributes();
    virtual void CopyAttributes(AttributeSubject *to, AttributeSubject *from);
};

class MetricThresholdGUIPluginInfo : public virtual GUIOperatorPluginInfo, public virtual MetricThresholdCommonPluginInfo
{
  public:
    virtual QString *GetMenuName() const;
    virtual QvisPostableWindowObserver *CreatePluginWindow(int type,
        AttributeSubject *attr, const QString &caption, const QString &shortName,
        QvisNotepadArea *notepad);
};

class MetricThresholdViewerEnginePluginInfo : public virtual ViewerEngineOperatorPluginInfo, public virtual MetricThresholdCommonPluginInfo
{
  public:
    virtual AttributeSubject *GetClientAtts();
    virtual AttributeSubject *GetDefaultAtts();
    virtual void SetClientAtts(AttributeSubject *atts);
    virtual void GetClientAtts(AttributeSubject *atts);

    virtual void InitializeOperatorAtts(AttributeSubject *atts,
                                        const avtPlotMetaData &plot,
                                        const bool fromDefault);
    virtual void UpdateOperatorAtts(AttributeSubject *atts,
                                    const avtPlotMetaData &plot);
    virtual const char *GetMenuName() const;

    static void InitializeGlobalObjects();
  private:
    static MetricThresholdAttributes *defaultAtts;
    static MetricThresholdAttributes *clientAtts;
};

class MetricThresholdViewerPluginInfo : public virtual ViewerOperatorPluginInfo, public virtual MetricThresholdViewerEnginePluginInfo
{
  public:
};

class MetricThresholdEnginePluginInfo : public virtual EngineOperatorPluginInfo, public virtual MetricThresholdViewerEnginePluginInfo
{
  public:
    virtual avtPluginFilter *AllocAvtPluginFilter();
};

class MetricThresholdScriptingPluginInfo : public virtual ScriptingOperatorPluginInfo, public virtual MetricThresholdCommonPluginInfo
{
  public:
    virtual void InitializePlugin(AttributeSubject *subj, void *data);
    virtual void *GetMethodTable(int *nMethods);
    virtual bool TypesMatch(void *pyobject);
    virtual char *GetLogString();
    virtual void SetDefaults(const AttributeSubject *atts);
};

#endif
