// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MetricThresholdPluginInfo.C
// ****************************************************************************

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>

#include <visit-config.h>
VISIT_PLUGIN_VERSION(MetricThreshold,OP_EXPORT)

VISIT_OPERATOR_PLUGIN_ENTRY(MetricThreshold,General)

// ****************************************************************************
//  Method: MetricThresholdGeneralPluginInfo::GetName
//
//  Purpose:
//    Return the name of the operator plugin.
//
//  Returns:    A pointer to the name of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MetricThresholdGeneralPluginInfo::GetName() const
{
    return "MetricThreshold";
}

// ****************************************************************************
//  Method: MetricThresholdGeneralPluginInfo::GetVersion
//
//  Purpose:
//    Return the version of the operator plugin.
//
//  Returns:    A pointer to the version of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MetricThresholdGeneralPluginInfo::GetVersion() const
{
    return "1.0";
}

// ****************************************************************************
//  Method: MetricThresholdGeneralPluginInfo::GetID
//
//  Purpose:
//    Return the id of the operator plugin.
//
//  Returns:    A pointer to the id of the operator plugin.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MetricThresholdGeneralPluginInfo::GetID() const
{
    return "MetricThreshold_1.0";
}
// ****************************************************************************
//  Method: MetricThresholdGeneralPluginInfo::EnabledByDefault
//
//  Purpose:
//    Return true if this plugin should be enabled by default; false otherwise.
//
//  Returns:    true/false
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

bool
MetricThresholdGeneralPluginInfo::EnabledByDefault() const
{
    return true;
}

// ****************************************************************************
//  Method: MetricThresholdGeneralPluginInfo::GetCategoryName
//
//  Purpose:
//    Return the category name to which the operator belongs.
//
//  Returns:    Return the category name to which the operator belongs.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

const char *
MetricThresholdGeneralPluginInfo::GetCategoryName() const
{
    return "Selection";
}
