// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MetricThresholdCommonPluginInfo.C
// ****************************************************************************

#include <MetricThresholdPluginInfo.h>
#include <MetricThresholdAttributes.h>

// ****************************************************************************
//  Method: MetricThresholdCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MetricThresholdCommonPluginInfo::AllocAttributes()
{
    return new MetricThresholdAttributes;
}

// ****************************************************************************
//  Method: MetricThresholdCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a MetricThreshold attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MetricThresholdCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((MetricThresholdAttributes *) to) = *((MetricThresholdAttributes *) from);
}
