// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ************************************************************************* //
//  File: avtMergeFilter.h
// ************************************************************************* //

#ifndef AVT_Merge_FILTER_H
#define AVT_Merge_FILTER_H


#include <avtSingleFilterFacade.h>
#include <avtPluginFilter.h>
#include <MergeOperatorAttributes.h>


class vtkDataSet;
class avtCompactTreeFilter;


// ****************************************************************************
//  Class: avtMergeFilter
//
//  Purpose:
//      A plugin operator for Merge.
//
//  Programmer: childs -- generated by xml2avt
//  Creation:   Sun Aug 14 17:16:45 PST 2005
//
//  Modifications:
//
//    Tom Fogal, Tue Jun 23 20:51:36 MDT 2009
//    Added const version of GetFacadedFilter.
//
// ****************************************************************************

class avtMergeFilter : virtual public avtPluginFilter,
                       virtual public avtSingleFilterFacade

{
  public:
                         avtMergeFilter();
    virtual             ~avtMergeFilter();

    static avtFilter    *Create();

    virtual const char  *GetType(void)  { return "avtMergeFilter"; };
    virtual const char  *GetDescription(void)
                             { return "Merging surfaces"; };

    virtual void         SetAtts(const AttributeGroup*);
    virtual bool         Equivalent(const AttributeGroup*);

  protected:
    MergeOperatorAttributes   atts;
    avtCompactTreeFilter     *ctf;

    virtual avtFilter        *GetFacadedFilter();
    virtual const avtFilter  *GetFacadedFilter() const;

    static void UpdateDataObjectInfoCB(avtDataObject_p &input,
                                       avtDataObject_p &output, void *);
};


#endif
