// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include "QvisMergeWindow.h"

#include <MergeOperatorAttributes.h>

#include <QCheckBox>
#include <QLabel>
#include <QLayout>
#include <QLineEdit>


// ****************************************************************************
// Method: QvisMergeWindow::QvisMergeWindow
//
// Purpose: 
//   Constructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMergeWindow::QvisMergeWindow(const int type,
                         MergeOperatorAttributes *subj,
                         const QString &caption,
                         const QString &shortName,
                         QvisNotepadArea *notepad)
    : QvisOperatorWindow(type,subj, caption, shortName, notepad)
{
    atts = subj;
}


// ****************************************************************************
// Method: QvisMergeWindow::~QvisMergeWindow
//
// Purpose: 
//   Destructor
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

QvisMergeWindow::~QvisMergeWindow()
{
}


// ****************************************************************************
// Method: QvisMergeWindow::CreateWindowContents
//
// Purpose: 
//   Creates the widgets for the window.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMergeWindow::CreateWindowContents()
{
    QGridLayout *mainLayout = new QGridLayout(0);
    topLayout->addLayout(mainLayout);

    parallelMerge = new QCheckBox(tr("Merge across all processors?"), central);
    connect(parallelMerge, SIGNAL(toggled(bool)),
            this, SLOT(parallelMergeChanged(bool)));
    mainLayout->addWidget(parallelMerge, 0,0);

    toleranceLabel = new QLabel(tr("Maximum distance between points that should be merged"), central);
    mainLayout->addWidget(toleranceLabel,1,0);
    tolerance = new QLineEdit(central);
    connect(tolerance, SIGNAL(returnPressed()),
            this, SLOT(toleranceProcessText()));
    mainLayout->addWidget(tolerance, 1,1);

}


// ****************************************************************************
// Method: QvisMergeWindow::UpdateWindow
//
// Purpose: 
//   Updates the widgets in the window when the subject changes.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMergeWindow::UpdateWindow(bool doAll)
{

    for(int i = 0; i < atts->NumAttributes(); ++i)
    {
        if(!doAll)
        {
            if(!atts->IsSelected(i))
            {
                continue;
            }
        }

        switch(i)
        {
          case MergeOperatorAttributes::ID_parallelMerge:
            parallelMerge->blockSignals(true);
            parallelMerge->setChecked(atts->GetParallelMerge());
            parallelMerge->blockSignals(false);
            break;
          case MergeOperatorAttributes::ID_tolerance:
            tolerance->setText(DoubleToQString(atts->GetTolerance()));
            break;
        }
    }
}


// ****************************************************************************
// Method: QvisMergeWindow::GetCurrentValues
//
// Purpose: 
//   Gets values from certain widgets and stores them in the subject.
//
// Note:       Autogenerated by xml2window.
//
// Programmer: xml2window
// Creation:   omitted
//
// Modifications:
//   
// ****************************************************************************

void
QvisMergeWindow::GetCurrentValues(int which_widget)
{
    bool doAll = (which_widget == -1);

    // Do tolerance
    if(which_widget == MergeOperatorAttributes::ID_tolerance || doAll)
    {
        double val;
        if(LineEditGetDouble(tolerance, val))
            atts->SetTolerance(val);
        else
        {
            ResettingError(tr("Maximum distance between points that should be merged"),
                DoubleToQString(atts->GetTolerance()));
            atts->SetTolerance(atts->GetTolerance());
        }
    }

}


//
// Qt Slot functions
//


void
QvisMergeWindow::parallelMergeChanged(bool val)
{
    atts->SetParallelMerge(val);
    SetUpdate(false);
    Apply();
}


void
QvisMergeWindow::toleranceProcessText()
{
    GetCurrentValues(MergeOperatorAttributes::ID_tolerance);
    Apply();
}


