// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

// ****************************************************************************
//  File: MergeCommonPluginInfo.C
// ****************************************************************************

#include <MergePluginInfo.h>
#include <MergeOperatorAttributes.h>

// ****************************************************************************
//  Method: MergeCommonPluginInfo::AllocAttributes
//
//  Purpose:
//    Return a pointer to a newly allocated attribute subject.
//
//  Returns:    A pointer to the newly allocated attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

AttributeSubject *
MergeCommonPluginInfo::AllocAttributes()
{
    return new MergeOperatorAttributes;
}

// ****************************************************************************
//  Method: MergeCommonPluginInfo::CopyAttributes
//
//  Purpose:
//    Copy a Merge attribute subject.
//
//  Arguments:
//    to        The destination attribute subject.
//    from      The source attribute subject.
//
//  Programmer: generated by xml2info
//  Creation:   omitted
//
// ****************************************************************************

void
MergeCommonPluginInfo::CopyAttributes(AttributeSubject *to,
    AttributeSubject *from)
{
    *((MergeOperatorAttributes *) to) = *((MergeOperatorAttributes *) from);
}
