// Copyright (c) Lawrence Livermore National Security, LLC and other VisIt
// Project developers.  See the top-level LICENSE file for dates and other
// details.  No copyright assignment is required to contribute to VisIt.

#include <PyLineoutAttributes.h>
#include <ObserverToCallback.h>
#include <stdio.h>

// ****************************************************************************
// Module: PyLineoutAttributes
//
// Purpose:
//   Attributes for the Lineout operator.
//
// Note:       Autogenerated by xml2python. Do not modify by hand!
//
// Programmer: xml2python
// Creation:   omitted
//
// ****************************************************************************

//
// This struct contains the Python type information and a LineoutAttributes.
//
struct LineoutAttributesObject
{
    PyObject_HEAD
    LineoutAttributes *data;
    bool        owns;
    PyObject   *parent;
};

//
// Internal prototypes
//
static PyObject *NewLineoutAttributes(int);

std::string
PyLineoutAttributes_ToString(const LineoutAttributes *atts, const char *prefix)
{
    std::string str;
    char tmpStr[1000];

    {   const double *point1 = atts->GetPoint1();
        snprintf(tmpStr, 1000, "%spoint1 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", point1[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    {   const double *point2 = atts->GetPoint2();
        snprintf(tmpStr, 1000, "%spoint2 = (", prefix);
        str += tmpStr;
        for(int i = 0; i < 3; ++i)
        {
            snprintf(tmpStr, 1000, "%g", point2[i]);
            str += tmpStr;
            if(i < 2)
            {
                snprintf(tmpStr, 1000, ", ");
                str += tmpStr;
            }
        }
        snprintf(tmpStr, 1000, ")\n");
        str += tmpStr;
    }
    if(atts->GetInteractive())
        snprintf(tmpStr, 1000, "%sinteractive = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sinteractive = 0\n", prefix);
    str += tmpStr;
    if(atts->GetIgnoreGlobal())
        snprintf(tmpStr, 1000, "%signoreGlobal = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%signoreGlobal = 0\n", prefix);
    str += tmpStr;
    if(atts->GetSamplingOn())
        snprintf(tmpStr, 1000, "%ssamplingOn = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%ssamplingOn = 0\n", prefix);
    str += tmpStr;
    snprintf(tmpStr, 1000, "%snumberOfSamplePoints = %d\n", prefix, atts->GetNumberOfSamplePoints());
    str += tmpStr;
    if(atts->GetReflineLabels())
        snprintf(tmpStr, 1000, "%sreflineLabels = 1\n", prefix);
    else
        snprintf(tmpStr, 1000, "%sreflineLabels = 0\n", prefix);
    str += tmpStr;
    return str;
}

static PyObject *
LineoutAttributes_Notify(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    obj->data->Notify();
    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_SetPoint1(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    double *dvals = obj->data->GetPoint1();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point1 in the object as modified.
    obj->data->SelectPoint1();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetPoint1(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point1.
    PyObject *retval = PyTuple_New(3);
    const double *point1 = obj->data->GetPoint1();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point1[i]));
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetPoint2(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    double *dvals = obj->data->GetPoint2();
    if(!PyArg_ParseTuple(args, "ddd", &dvals[0], &dvals[1], &dvals[2]))
    {
        PyObject     *tuple;
        if(!PyArg_ParseTuple(args, "O", &tuple))
            return NULL;

        if(PyTuple_Check(tuple))
        {
            if(PyTuple_Size(tuple) != 3)
                return NULL;

            PyErr_Clear();
            for(int i = 0; i < PyTuple_Size(tuple); ++i)
            {
                PyObject *item = PyTuple_GET_ITEM(tuple, i);
                if(PyFloat_Check(item))
                    dvals[i] = PyFloat_AS_DOUBLE(item);
                else if(PyInt_Check(item))
                    dvals[i] = double(PyInt_AS_LONG(item));
                else if(PyLong_Check(item))
                    dvals[i] = PyLong_AsDouble(item);
                else
                    dvals[i] = 0.;
            }
        }
        else
            return NULL;
    }

    // Mark the point2 in the object as modified.
    obj->data->SelectPoint2();

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetPoint2(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    // Allocate a tuple the with enough entries to hold the point2.
    PyObject *retval = PyTuple_New(3);
    const double *point2 = obj->data->GetPoint2();
    for(int i = 0; i < 3; ++i)
        PyTuple_SET_ITEM(retval, i, PyFloat_FromDouble(point2[i]));
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetInteractive(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the interactive in the object.
    obj->data->SetInteractive(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetInteractive(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetInteractive()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetIgnoreGlobal(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the ignoreGlobal in the object.
    obj->data->SetIgnoreGlobal(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetIgnoreGlobal(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetIgnoreGlobal()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetSamplingOn(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the samplingOn in the object.
    obj->data->SetSamplingOn(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetSamplingOn(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetSamplingOn()?1L:0L);
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetNumberOfSamplePoints(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the numberOfSamplePoints in the object.
    obj->data->SetNumberOfSamplePoints((int)ival);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetNumberOfSamplePoints(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(long(obj->data->GetNumberOfSamplePoints()));
    return retval;
}

/*static*/ PyObject *
LineoutAttributes_SetReflineLabels(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;

    int ival;
    if(!PyArg_ParseTuple(args, "i", &ival))
        return NULL;

    // Set the reflineLabels in the object.
    obj->data->SetReflineLabels(ival != 0);

    Py_INCREF(Py_None);
    return Py_None;
}

/*static*/ PyObject *
LineoutAttributes_GetReflineLabels(PyObject *self, PyObject *args)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)self;
    PyObject *retval = PyInt_FromLong(obj->data->GetReflineLabels()?1L:0L);
    return retval;
}



PyMethodDef PyLineoutAttributes_methods[LINEOUTATTRIBUTES_NMETH] = {
    {"Notify", LineoutAttributes_Notify, METH_VARARGS},
    {"SetPoint1", LineoutAttributes_SetPoint1, METH_VARARGS},
    {"GetPoint1", LineoutAttributes_GetPoint1, METH_VARARGS},
    {"SetPoint2", LineoutAttributes_SetPoint2, METH_VARARGS},
    {"GetPoint2", LineoutAttributes_GetPoint2, METH_VARARGS},
    {"SetInteractive", LineoutAttributes_SetInteractive, METH_VARARGS},
    {"GetInteractive", LineoutAttributes_GetInteractive, METH_VARARGS},
    {"SetIgnoreGlobal", LineoutAttributes_SetIgnoreGlobal, METH_VARARGS},
    {"GetIgnoreGlobal", LineoutAttributes_GetIgnoreGlobal, METH_VARARGS},
    {"SetSamplingOn", LineoutAttributes_SetSamplingOn, METH_VARARGS},
    {"GetSamplingOn", LineoutAttributes_GetSamplingOn, METH_VARARGS},
    {"SetNumberOfSamplePoints", LineoutAttributes_SetNumberOfSamplePoints, METH_VARARGS},
    {"GetNumberOfSamplePoints", LineoutAttributes_GetNumberOfSamplePoints, METH_VARARGS},
    {"SetReflineLabels", LineoutAttributes_SetReflineLabels, METH_VARARGS},
    {"GetReflineLabels", LineoutAttributes_GetReflineLabels, METH_VARARGS},
    {NULL, NULL}
};

//
// Type functions
//

static void
LineoutAttributes_dealloc(PyObject *v)
{
   LineoutAttributesObject *obj = (LineoutAttributesObject *)v;
   if(obj->parent != 0)
       Py_DECREF(obj->parent);
   if(obj->owns)
       delete obj->data;
}

static int
LineoutAttributes_compare(PyObject *v, PyObject *w)
{
    LineoutAttributes *a = ((LineoutAttributesObject *)v)->data;
    LineoutAttributes *b = ((LineoutAttributesObject *)w)->data;
    return (*a == *b) ? 0 : -1;
}

PyObject *
PyLineoutAttributes_getattr(PyObject *self, char *name)
{
    if(strcmp(name, "point1") == 0)
        return LineoutAttributes_GetPoint1(self, NULL);
    if(strcmp(name, "point2") == 0)
        return LineoutAttributes_GetPoint2(self, NULL);
    if(strcmp(name, "interactive") == 0)
        return LineoutAttributes_GetInteractive(self, NULL);
    if(strcmp(name, "ignoreGlobal") == 0)
        return LineoutAttributes_GetIgnoreGlobal(self, NULL);
    if(strcmp(name, "samplingOn") == 0)
        return LineoutAttributes_GetSamplingOn(self, NULL);
    if(strcmp(name, "numberOfSamplePoints") == 0)
        return LineoutAttributes_GetNumberOfSamplePoints(self, NULL);
    if(strcmp(name, "reflineLabels") == 0)
        return LineoutAttributes_GetReflineLabels(self, NULL);

    return Py_FindMethod(PyLineoutAttributes_methods, self, name);
}

int
PyLineoutAttributes_setattr(PyObject *self, char *name, PyObject *args)
{
    // Create a tuple to contain the arguments since all of the Set
    // functions expect a tuple.
    PyObject *tuple = PyTuple_New(1);
    PyTuple_SET_ITEM(tuple, 0, args);
    Py_INCREF(args);
    PyObject *obj = NULL;

    if(strcmp(name, "point1") == 0)
        obj = LineoutAttributes_SetPoint1(self, tuple);
    else if(strcmp(name, "point2") == 0)
        obj = LineoutAttributes_SetPoint2(self, tuple);
    else if(strcmp(name, "interactive") == 0)
        obj = LineoutAttributes_SetInteractive(self, tuple);
    else if(strcmp(name, "ignoreGlobal") == 0)
        obj = LineoutAttributes_SetIgnoreGlobal(self, tuple);
    else if(strcmp(name, "samplingOn") == 0)
        obj = LineoutAttributes_SetSamplingOn(self, tuple);
    else if(strcmp(name, "numberOfSamplePoints") == 0)
        obj = LineoutAttributes_SetNumberOfSamplePoints(self, tuple);
    else if(strcmp(name, "reflineLabels") == 0)
        obj = LineoutAttributes_SetReflineLabels(self, tuple);

    if(obj != NULL)
        Py_DECREF(obj);

    Py_DECREF(tuple);
    if( obj == NULL)
        PyErr_Format(PyExc_RuntimeError, "Unable to set unknown attribute: '%s'", name);
    return (obj != NULL) ? 0 : -1;
}

static int
LineoutAttributes_print(PyObject *v, FILE *fp, int flags)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)v;
    fprintf(fp, "%s", PyLineoutAttributes_ToString(obj->data, "").c_str());
    return 0;
}

PyObject *
LineoutAttributes_str(PyObject *v)
{
    LineoutAttributesObject *obj = (LineoutAttributesObject *)v;
    return PyString_FromString(PyLineoutAttributes_ToString(obj->data,"").c_str());
}

//
// The doc string for the class.
//
#if PY_MAJOR_VERSION > 2 || (PY_MAJOR_VERSION == 2 && PY_MINOR_VERSION >= 5)
static const char *LineoutAttributes_Purpose = "Attributes for the Lineout operator.";
#else
static char *LineoutAttributes_Purpose = "Attributes for the Lineout operator.";
#endif

//
// The type description structure
//
static PyTypeObject LineoutAttributesType =
{
    //
    // Type header
    //
    PyObject_HEAD_INIT(&PyType_Type)
    0,                                   // ob_size
    "LineoutAttributes",                    // tp_name
    sizeof(LineoutAttributesObject),        // tp_basicsize
    0,                                   // tp_itemsize
    //
    // Standard methods
    //
    (destructor)LineoutAttributes_dealloc,  // tp_dealloc
    (printfunc)LineoutAttributes_print,     // tp_print
    (getattrfunc)PyLineoutAttributes_getattr, // tp_getattr
    (setattrfunc)PyLineoutAttributes_setattr, // tp_setattr
    (cmpfunc)LineoutAttributes_compare,     // tp_compare
    (reprfunc)0,                         // tp_repr
    //
    // Type categories
    //
    0,                                   // tp_as_number
    0,                                   // tp_as_sequence
    0,                                   // tp_as_mapping
    //
    // More methods
    //
    0,                                   // tp_hash
    0,                                   // tp_call
    (reprfunc)LineoutAttributes_str,        // tp_str
    0,                                   // tp_getattro
    0,                                   // tp_setattro
    0,                                   // tp_as_buffer
    Py_TPFLAGS_CHECKTYPES,               // tp_flags
    LineoutAttributes_Purpose,              // tp_doc
    0,                                   // tp_traverse
    0,                                   // tp_clear
    0,                                   // tp_richcompare
    0                                    // tp_weaklistoffset
};

//
// Helper functions for object allocation.
//

static LineoutAttributes *defaultAtts = 0;
static LineoutAttributes *currentAtts = 0;

static PyObject *
NewLineoutAttributes(int useCurrent)
{
    LineoutAttributesObject *newObject;
    newObject = PyObject_NEW(LineoutAttributesObject, &LineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    if(useCurrent && currentAtts != 0)
        newObject->data = new LineoutAttributes(*currentAtts);
    else if(defaultAtts != 0)
        newObject->data = new LineoutAttributes(*defaultAtts);
    else
        newObject->data = new LineoutAttributes;
    newObject->owns = true;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

static PyObject *
WrapLineoutAttributes(const LineoutAttributes *attr)
{
    LineoutAttributesObject *newObject;
    newObject = PyObject_NEW(LineoutAttributesObject, &LineoutAttributesType);
    if(newObject == NULL)
        return NULL;
    newObject->data = (LineoutAttributes *)attr;
    newObject->owns = false;
    newObject->parent = 0;
    return (PyObject *)newObject;
}

///////////////////////////////////////////////////////////////////////////////
//
// Interface that is exposed to the VisIt module.
//
///////////////////////////////////////////////////////////////////////////////

PyObject *
LineoutAttributes_new(PyObject *self, PyObject *args)
{
    int useCurrent = 0;
    if (!PyArg_ParseTuple(args, "i", &useCurrent))
    {
        if (!PyArg_ParseTuple(args, ""))
            return NULL;
        else
            PyErr_Clear();
    }

    return (PyObject *)NewLineoutAttributes(useCurrent);
}

//
// Plugin method table. These methods are added to the visitmodule's methods.
//
static PyMethodDef LineoutAttributesMethods[] = {
    {"LineoutAttributes", LineoutAttributes_new, METH_VARARGS},
    {NULL,      NULL}        /* Sentinel */
};

static Observer *LineoutAttributesObserver = 0;

std::string
PyLineoutAttributes_GetLogString()
{
    std::string s("LineoutAtts = LineoutAttributes()\n");
    if(currentAtts != 0)
        s += PyLineoutAttributes_ToString(currentAtts, "LineoutAtts.");
    return s;
}

static void
PyLineoutAttributes_CallLogRoutine(Subject *subj, void *data)
{
    typedef void (*logCallback)(const std::string &);
    logCallback cb = (logCallback)data;

    if(cb != 0)
    {
        std::string s("LineoutAtts = LineoutAttributes()\n");
        s += PyLineoutAttributes_ToString(currentAtts, "LineoutAtts.");
        cb(s);
    }
}

void
PyLineoutAttributes_StartUp(LineoutAttributes *subj, void *data)
{
    if(subj == 0)
        return;

    currentAtts = subj;
    PyLineoutAttributes_SetDefaults(subj);

    //
    // Create the observer that will be notified when the attributes change.
    //
    if(LineoutAttributesObserver == 0)
    {
        LineoutAttributesObserver = new ObserverToCallback(subj,
            PyLineoutAttributes_CallLogRoutine, (void *)data);
    }

}

void
PyLineoutAttributes_CloseDown()
{
    delete defaultAtts;
    defaultAtts = 0;
    delete LineoutAttributesObserver;
    LineoutAttributesObserver = 0;
}

PyMethodDef *
PyLineoutAttributes_GetMethodTable(int *nMethods)
{
    *nMethods = 1;
    return LineoutAttributesMethods;
}

bool
PyLineoutAttributes_Check(PyObject *obj)
{
    return (obj->ob_type == &LineoutAttributesType);
}

LineoutAttributes *
PyLineoutAttributes_FromPyObject(PyObject *obj)
{
    LineoutAttributesObject *obj2 = (LineoutAttributesObject *)obj;
    return obj2->data;
}

PyObject *
PyLineoutAttributes_New()
{
    return NewLineoutAttributes(0);
}

PyObject *
PyLineoutAttributes_Wrap(const LineoutAttributes *attr)
{
    return WrapLineoutAttributes(attr);
}

void
PyLineoutAttributes_SetParent(PyObject *obj, PyObject *parent)
{
    LineoutAttributesObject *obj2 = (LineoutAttributesObject *)obj;
    obj2->parent = parent;
}

void
PyLineoutAttributes_SetDefaults(const LineoutAttributes *atts)
{
    if(defaultAtts)
        delete defaultAtts;

    defaultAtts = new LineoutAttributes(*atts);
}

